/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xtpdoc;

import com.caucho.xtpdoc.ContentItem;
import com.caucho.xtpdoc.Document;
import com.caucho.xtpdoc.LaTeXUtil;
import com.caucho.xtpdoc.S4;
import com.caucho.xtpdoc.Section;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class S3
extends Section {
    public S3(Document document, String parentHref) {
        super(document, parentHref);
    }

    public S4 createS4() {
        S4 s4 = new S4(this.getDocument(), this.getHref());
        this.addItem(s4);
        return s4;
    }

    public void writeHtml(XMLStreamWriter out) throws XMLStreamException {
        out.writeCharacters("\n");
        out.writeStartElement("div");
        out.writeAttribute("class", "s3");
        out.writeStartElement("a");
        out.writeAttribute("name", this.getHref());
        out.writeEndElement();
        if (this._title != null) {
            out.writeStartElement("h3");
            out.writeCharacters(this._title);
            out.writeEndElement();
        }
        for (ContentItem item : this.getItems()) {
            item.writeHtml(out);
        }
        out.writeEndElement();
    }

    public void writeLaTeXTop(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\subsubsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeX(out);
    }

    public void writeLaTeX(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            if (this.isArticle()) {
                out.println("\\subsubsection{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            } else {
                out.println("\\paragraph{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
            }
        }
        super.writeLaTeX(out);
    }

    public void writeLaTeXEnclosed(PrintWriter out) throws IOException {
        if (this._type != null && this._type.equals("defun")) {
            out.println("\\newpage");
        }
        if (this._title != null) {
            out.println("\\textbf{" + LaTeXUtil.escapeForLaTeX(this._title) + "}");
        }
        super.writeLaTeX(out);
    }

    public void writeAsciiDoc(PrintWriter out) throws IOException {
        if (this.isWebOnly()) {
            return;
        }
        out.println();
        out.println();
        out.println("===== " + this._title + " =====");
        super.writeAsciiDoc(out);
    }
}

