/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AbstractJmxAction;
import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.ListJmxQueryReply;
import com.caucho.util.L10N;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class ListJmxAction
extends AbstractJmxAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(ListJmxAction.class.getName());
    private static final L10N L = new L10N(ListJmxAction.class);

    public ListJmxQueryReply execute(String pattern, boolean isPrintAttributes, boolean isPrintValues, boolean isPrintOperations, boolean isAllBeans, boolean isUsePlatform) throws ConfigException, JMException, ClassNotFoundException {
        LinkedList<MBeanServer> servers = new LinkedList<MBeanServer>();
        if (isUsePlatform) {
            servers.add(ManagementFactory.getPlatformMBeanServer());
        } else {
            servers.addAll(MBeanServerFactory.findMBeanServer(null));
        }
        HashSet<ObjectName> beans = new HashSet<ObjectName>();
        ObjectName nameQuery = null;
        nameQuery = pattern != null ? ObjectName.getInstance(pattern) : (isAllBeans ? ObjectName.WILDCARD : (nameQuery == null && isUsePlatform ? ObjectName.getInstance("java.lang:*") : ObjectName.getInstance("resin:*")));
        ListJmxQueryReply listJmxQueryResult = new ListJmxQueryReply();
        for (MBeanServer server : servers) {
            Set<ObjectName> mbeanSet = server.queryNames(nameQuery, null);
            ArrayList<ObjectName> mbeans = new ArrayList<ObjectName>(mbeanSet);
            Collections.sort(mbeans);
            for (ObjectName mbean : mbeans) {
                if (beans.contains(mbean)) continue;
                beans.add(mbean);
                ListJmxQueryReply.Bean bean = new ListJmxQueryReply.Bean();
                bean.setName(mbean.toString());
                if (isPrintAttributes || isPrintValues) {
                    MBeanAttributeInfo[] attributes;
                    for (MBeanAttributeInfo attribute : attributes = server.getMBeanInfo(mbean).getAttributes()) {
                        ListJmxQueryReply.Attribute attr = new ListJmxQueryReply.Attribute();
                        attr.setName(attribute.getName());
                        attr.setInfo(attribute.toString());
                        if (isPrintValues) {
                            try {
                                Object value = server.getAttribute(mbean, attribute.getName());
                                attr.setValue(value);
                            }
                            catch (Exception e) {
                                log.log(Level.FINER, e.getMessage(), e);
                                attr.setValue(e);
                            }
                        }
                        bean.add(attr);
                    }
                }
                if (isPrintOperations) {
                    for (MBeanOperationInfo operation : server.getMBeanInfo(mbean).getOperations()) {
                        ListJmxQueryReply.Operation op = new ListJmxQueryReply.Operation();
                        op.setName(operation.getName());
                        MBeanParameterInfo[] params = operation.getSignature();
                        if (params.length > 0) {
                            for (int i = 0; i < params.length; ++i) {
                                MBeanParameterInfo param = params[i];
                                ListJmxQueryReply.Param par = new ListJmxQueryReply.Param();
                                par.setName(param.getName());
                                par.setType(param.getType());
                                par.setDescription(param.getDescription());
                                op.add(par);
                            }
                        }
                        op.setDescription(operation.getDescription());
                        op.setType(operation.getReturnType());
                        bean.add(op);
                    }
                }
                listJmxQueryResult.add(bean);
            }
        }
        return listJmxQueryResult;
    }
}

