/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.AssociationOverrideConfig;
import com.caucho.amber.cfg.AttributeOverrideConfig;
import com.caucho.amber.cfg.BasicConfig;
import com.caucho.amber.cfg.ColumnConfig;
import com.caucho.amber.cfg.DiscriminatorColumnConfig;
import com.caucho.amber.cfg.EmbeddableConfig;
import com.caucho.amber.cfg.EmbeddedIdConfig;
import com.caucho.amber.cfg.EntityConfig;
import com.caucho.amber.cfg.EntityListenersConfig;
import com.caucho.amber.cfg.GeneratedValueConfig;
import com.caucho.amber.cfg.IdClassConfig;
import com.caucho.amber.cfg.IdConfig;
import com.caucho.amber.cfg.InheritanceConfig;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.cfg.JoinTableConfig;
import com.caucho.amber.cfg.ManyToManyConfig;
import com.caucho.amber.cfg.ManyToOneConfig;
import com.caucho.amber.cfg.MapKeyConfig;
import com.caucho.amber.cfg.MappedSuperclassConfig;
import com.caucho.amber.cfg.NamedNativeQueryConfig;
import com.caucho.amber.cfg.NamedQueryConfig;
import com.caucho.amber.cfg.OneToManyConfig;
import com.caucho.amber.cfg.OneToOneConfig;
import com.caucho.amber.cfg.PostLoadConfig;
import com.caucho.amber.cfg.PostPersistConfig;
import com.caucho.amber.cfg.PostRemoveConfig;
import com.caucho.amber.cfg.PostUpdateConfig;
import com.caucho.amber.cfg.PrePersistConfig;
import com.caucho.amber.cfg.PreRemoveConfig;
import com.caucho.amber.cfg.PreUpdateConfig;
import com.caucho.amber.cfg.PrimaryKeyJoinColumnConfig;
import com.caucho.amber.cfg.SecondaryTableConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.cfg.TableConfig;
import com.caucho.amber.cfg.VersionConfig;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.persistence.JoinColumn;
import javax.persistence.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigIntrospector {
    private static final Logger log = Logger.getLogger(AbstractConfigIntrospector.class.getName());
    private static final L10N L = new L10N(AbstractConfigIntrospector.class);
    static HashSet<String> _propertyAnnotations = new HashSet();
    static HashSet<String> _basicTypes = new HashSet();
    static HashSet<String> _basicAnnotations = new HashSet();
    static HashSet<String> _idTypes = new HashSet();
    static HashSet<String> _idAnnotations = new HashSet();
    static HashSet<String> _manyToOneAnnotations = new HashSet();
    static HashSet<String> _oneToManyAnnotations = new HashSet();
    static HashSet<String> _oneToManyTypes = new HashSet();
    static HashSet<String> _manyToManyAnnotations = new HashSet();
    static HashSet<String> _manyToManyTypes = new HashSet();
    static HashSet<String> _oneToOneAnnotations = new HashSet();
    static HashSet<String> _elementCollectionAnnotations = new HashSet();
    static HashSet<String> _elementCollectionTypes = new HashSet();
    static HashSet<String> _embeddedAnnotations = new HashSet();
    static HashSet<String> _embeddedIdAnnotations = new HashSet();
    static HashSet<String> _versionAnnotations = new HashSet();
    static HashSet<String> _versionTypes = new HashSet();
    AnnotationConfig _annotationCfg = new AnnotationConfig();

    void validateCallback(String callbackName, Method method, boolean isListener) throws ConfigException {
        if (Modifier.isFinal(method.getModifiers())) {
            throw AbstractConfigIntrospector.error(method, L.l("'{0}' must not be final.  @{1} methods may not be final.", (Object)AbstractConfigIntrospector.getFullName(method), (Object)callbackName));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw AbstractConfigIntrospector.error(method, L.l("'{0}' must not be static.  @{1} methods may not be static.", (Object)AbstractConfigIntrospector.getFullName(method), (Object)callbackName));
        }
        Class<?>[] params = method.getParameterTypes();
        if (isListener) {
            if (params.length != 1) {
                throw AbstractConfigIntrospector.error(method, L.l("'{0}' must have the <METHOD>(Object) signature for entity listeners.", (Object)AbstractConfigIntrospector.getFullName(method)));
            }
        } else if (params.length != 0) {
            throw AbstractConfigIntrospector.error(method, L.l("'{0}' must not have any arguments.  @{1} methods have zero arguments for entities or mapped superclasses.", (Object)AbstractConfigIntrospector.getFullName(method), (Object)callbackName));
        }
    }

    public void validateType(Class type, boolean isEntity) throws ConfigException {
        if (Modifier.isFinal(type.getModifiers())) {
            throw new ConfigException(L.l("'{0}' must not be final.  Entity beans may not be final.", (Object)type.getName()));
        }
        if (isEntity) {
            this.validateConstructor(type);
        }
        for (Method method : type.getMethods()) {
            if (method.getDeclaringClass().getName().equals("java.lang.Object") || !Modifier.isFinal(method.getModifiers())) continue;
            throw AbstractConfigIntrospector.error(method, L.l("'{0}' must not be final.  Entity beans methods may not be final.", (Object)AbstractConfigIntrospector.getFullName(method)));
        }
    }

    public void validateConstructor(Class type) throws ConfigException {
        for (Constructor<?> ctor : type.getDeclaredConstructors()) {
            Class<?>[] param = ctor.getParameterTypes();
            if (param.length != 0 || !Modifier.isPublic(ctor.getModifiers()) && !Modifier.isProtected(ctor.getModifiers())) continue;
            return;
        }
        throw new ConfigException(L.l("'{0}' needs a public or protected no-arg constructor.  Entity beans must have a public or protected no-arg constructor.", (Object)type.getName()));
    }

    public void validateNonGetter(Method method) throws ConfigException {
        Annotation ann = this.isAnnotatedMethod(method);
        if (ann != null && !(ann instanceof Version)) {
            throw AbstractConfigIntrospector.error(method, L.l("'{0}' is not a valid annotation for {1}.  Only public getters and fields may have property annotations.", (Object)ann, (Object)AbstractConfigIntrospector.getFullName(method)));
        }
    }

    Annotation isAnnotatedMethod(Method method) throws ConfigException {
        for (Annotation ann : method.getDeclaredAnnotations()) {
            if (!_propertyAnnotations.contains(ann.getClass().getName())) continue;
            return ann;
        }
        return null;
    }

    static boolean containsFieldOrCompletion(AmberBeanType type, String fieldName) {
        while (type != null) {
            if (type.getField(fieldName) != null) {
                return true;
            }
            if (type.containsCompletionField(fieldName)) {
                return true;
            }
            if (!(type instanceof EntityType)) continue;
            type = ((EntityType)type).getParentType();
        }
        return false;
    }

    static void validateAnnotations(AccessibleObject field, String fieldName, String fieldType, HashSet<String> validAnnotations) throws ConfigException {
        for (Annotation ann : field.getDeclaredAnnotations()) {
            String name = ann.getClass().getName();
            if (!name.startsWith("javax.persistence") || validAnnotations.contains(name)) continue;
            throw AbstractConfigIntrospector.error(field, L.l("{0} may not have a @{1} annotation.  {2} does not allow @{3}.", (Object)fieldName, (Object)name, (Object)fieldType, (Object)name));
        }
    }

    static String getFullName(Method method) {
        return method.getName();
    }

    static String toFieldName(String name) {
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    static ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, EntityType type, JoinColumn[] joinColumns) {
        if (joinColumns == null || joinColumns.length == 0) {
            return AbstractConfigIntrospector.calculateColumns(mapTable, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        for (int i = 0; i < joinColumns.length; ++i) {
            JoinColumn joinColumn = joinColumns[i];
            ForeignColumn foreignColumn = mapTable.createForeignColumn(joinColumn.name(), type.getId().getKey().getColumns().get(0));
            columns.add(foreignColumn);
        }
        return columns;
    }

    static ArrayList<ForeignColumn> calculateColumns(AccessibleObject field, String fieldName, AmberTable mapTable, String prefix, EntityType type, JoinColumn[] joinColumnsAnn, HashMap<String, JoinColumnConfig> joinColumnsConfig) throws ConfigException {
        ArrayList<IdField> idFields;
        if (!(joinColumnsAnn != null && joinColumnsAnn.length != 0 || joinColumnsConfig != null && joinColumnsConfig.size() != 0)) {
            return AbstractConfigIntrospector.calculateColumns(mapTable, prefix, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        if (type.getId() == null) {
            throw AbstractConfigIntrospector.error(field, L.l("Entity {0} has no primary key defined.", (Object)type.getName()));
        }
        int len = joinColumnsAnn != null ? joinColumnsAnn.length : joinColumnsConfig.size();
        if (len != (idFields = type.getId().getKeys()).size()) {
            throw AbstractConfigIntrospector.error(field, L.l("@JoinColumns for {0} do not match number of the primary key columns in {1}.  The foreign key columns must match the primary key columns.", (Object)fieldName, (Object)type.getName()));
        }
        Iterator<JoinColumnConfig> it = null;
        if (joinColumnsConfig != null) {
            it = joinColumnsConfig.values().iterator();
        }
        for (int i = 0; i < len; ++i) {
            String name;
            if (joinColumnsAnn != null) {
                name = joinColumnsAnn[i].name();
            } else {
                JoinColumnConfig joinColumnConfig = it.next();
                name = joinColumnConfig.getName();
            }
            ForeignColumn foreignColumn = mapTable.createForeignColumn(name, idFields.get(i).getColumns().get(0));
            columns.add(foreignColumn);
        }
        return columns;
    }

    static ConfigException error(AccessibleObject field, String msg) {
        if (field instanceof Field) {
            return AbstractConfigIntrospector.error((Field)field, msg);
        }
        return AbstractConfigIntrospector.error((Method)field, msg);
    }

    static ConfigException error(Field field, String msg) {
        String className = field.getDeclaringClass().getName();
        int line = 0;
        if (line > 0) {
            return new ConfigException(className + ":" + line + ": " + msg);
        }
        return new ConfigException(className + "." + field.getName() + ": " + msg);
    }

    static ConfigException error(Method field, String msg) {
        String className = field.getDeclaringClass().getName();
        int line = 0;
        if (line > 0) {
            return new ConfigException(className + ":" + line + ": " + msg);
        }
        return new ConfigException(className + "." + field.getName() + ": " + msg);
    }

    static ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(key.getName(), key));
        }
        return columns;
    }

    static ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, String prefix, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(prefix + key.getName(), key));
        }
        return columns;
    }

    protected static String loc(Method method) {
        return method.getDeclaringClass().getSimpleName() + "." + method.getName() + ": ";
    }

    protected static String loc(Field field) {
        return field.getDeclaringClass().getSimpleName() + "." + field.getName() + ": ";
    }

    public static String toSqlName(String name) {
        return name;
    }

    static {
        _basicAnnotations.add("javax.persistence.Basic");
        _basicAnnotations.add("javax.persistence.Column");
        _basicAnnotations.add("javax.persistence.Enumerated");
        _basicAnnotations.add("javax.persistence.Lob");
        _basicAnnotations.add("javax.persistence.Temporal");
        _basicTypes.add("boolean");
        _basicTypes.add("byte");
        _basicTypes.add("char");
        _basicTypes.add("short");
        _basicTypes.add("int");
        _basicTypes.add("long");
        _basicTypes.add("float");
        _basicTypes.add("double");
        _basicTypes.add("[byte");
        _basicTypes.add("[char");
        _basicTypes.add("[java.lang.Byte");
        _basicTypes.add("[java.lang.Character");
        _idAnnotations.add("javax.persistence.Column");
        _idAnnotations.add("javax.persistence.GeneratedValue");
        _idAnnotations.add("javax.persistence.Id");
        _idAnnotations.add("javax.persistence.SequenceGenerator");
        _idAnnotations.add("javax.persistence.TableGenerator");
        _idAnnotations.add("javax.persistence.Temporal");
        _idTypes.add("boolean");
        _idTypes.add("byte");
        _idTypes.add("char");
        _idTypes.add("short");
        _idTypes.add("int");
        _idTypes.add("long");
        _idTypes.add("float");
        _idTypes.add("double");
        _idTypes.add("java.lang.Boolean");
        _idTypes.add("java.lang.Byte");
        _idTypes.add("java.lang.Character");
        _idTypes.add("java.lang.Short");
        _idTypes.add("java.lang.Integer");
        _idTypes.add("java.lang.Long");
        _idTypes.add("java.lang.Float");
        _idTypes.add("java.lang.Double");
        _idTypes.add("java.lang.String");
        _idTypes.add("java.util.Date");
        _idTypes.add("java.sql.Date");
        _manyToOneAnnotations.add("javax.persistence.ManyToOne");
        _manyToOneAnnotations.add("javax.persistence.JoinColumn");
        _manyToOneAnnotations.add("javax.persistence.JoinColumns");
        _oneToManyAnnotations.add("javax.persistence.OneToMany");
        _oneToManyAnnotations.add("javax.persistence.JoinTable");
        _oneToManyAnnotations.add("javax.persistence.MapKey");
        _oneToManyAnnotations.add("javax.persistence.OrderBy");
        _oneToManyTypes.add("java.util.Collection");
        _oneToManyTypes.add("java.util.List");
        _oneToManyTypes.add("java.util.Set");
        _oneToManyTypes.add("java.util.Map");
        _manyToManyAnnotations.add("javax.persistence.ManyToMany");
        _manyToManyAnnotations.add("javax.persistence.JoinTable");
        _manyToManyAnnotations.add("javax.persistence.MapKey");
        _manyToManyAnnotations.add("javax.persistence.OrderBy");
        _manyToManyTypes.add("java.util.Collection");
        _manyToManyTypes.add("java.util.List");
        _manyToManyTypes.add("java.util.Set");
        _manyToManyTypes.add("java.util.Map");
        _oneToOneAnnotations.add("javax.persistence.OneToOne");
        _oneToOneAnnotations.add("javax.persistence.JoinColumn");
        _oneToOneAnnotations.add("javax.persistence.JoinColumns");
        _elementCollectionAnnotations.add("javax.persistence.ElementCollection");
        _elementCollectionTypes.add("java.util.Collection");
        _elementCollectionTypes.add("java.util.List");
        _elementCollectionTypes.add("java.util.Set");
        _elementCollectionTypes.add("java.util.Map");
        _embeddedAnnotations.add("javax.persistence.Embedded");
        _embeddedAnnotations.add("javax.persistence.AttributeOverride");
        _embeddedAnnotations.add("javax.persistence.AttributeOverrides");
        _embeddedAnnotations.add("javax.persistence.Column");
        _embeddedIdAnnotations.add("javax.persistence.EmbeddedId");
        _embeddedIdAnnotations.add("javax.persistence.AttributeOverride");
        _embeddedIdAnnotations.add("javax.persistence.AttributeOverrides");
        _propertyAnnotations.add("javax.persistence.Basic");
        _propertyAnnotations.add("javax.persistence.Column");
        _propertyAnnotations.add("javax.persistence.Id");
        _propertyAnnotations.add("javax.persistence.Transient");
        _propertyAnnotations.add("javax.persistence.OneToOne");
        _propertyAnnotations.add("javax.persistence.ManyToOne");
        _propertyAnnotations.add("javax.persistence.OneToMany");
        _propertyAnnotations.add("javax.persistence.ManyToMany");
        _propertyAnnotations.add("javax.persistence.JoinColumn");
        _propertyAnnotations.add("javax.persistence.Embedded");
        _propertyAnnotations.add("javax.persistence.EmbeddedId");
        _propertyAnnotations.add("javax.persistence.Version");
        _versionAnnotations.add("javax.persistence.Version");
        _versionAnnotations.add("javax.persistence.Column");
        _versionAnnotations.add("javax.persistence.Temporal");
        _versionTypes.add("short");
        _versionTypes.add("int");
        _versionTypes.add("long");
        _versionTypes.add("java.lang.Short");
        _versionTypes.add("java.lang.Integer");
        _versionTypes.add("java.lang.Long");
        _versionTypes.add("java.sql.Timestamp");
    }

    class AnnotationConfig {
        private Annotation _annotation;
        private Object _config;

        AnnotationConfig() {
        }

        public Annotation getAnnotation() {
            return this._annotation;
        }

        public Object getConfig() {
            return this._config;
        }

        public void setAnnotation(Annotation annotation) {
            this._annotation = annotation;
        }

        public void setConfig(Object config) {
            this._config = config;
        }

        public boolean isNull() {
            return this._annotation == null && this._config == null;
        }

        public void reset() {
            this._annotation = null;
            this._config = null;
        }

        public void reset(Class type, Class cl) {
            this._annotation = type.getAnnotation(cl);
            this._config = null;
        }

        public void reset(AccessibleObject field, Class cl) {
            this._annotation = field.getAnnotation(cl);
            this._config = null;
        }

        public EmbeddableConfig getEmbeddableConfig() {
            return (EmbeddableConfig)this._config;
        }

        public EntityConfig getEntityConfig() {
            return (EntityConfig)this._config;
        }

        public MappedSuperclassConfig getMappedSuperclassConfig() {
            return (MappedSuperclassConfig)this._config;
        }

        public EntityListenersConfig getEntityListenersConfig() {
            return (EntityListenersConfig)this._config;
        }

        public TableConfig getTableConfig() {
            return (TableConfig)this._config;
        }

        public SecondaryTableConfig getSecondaryTableConfig() {
            return (SecondaryTableConfig)this._config;
        }

        public IdClassConfig getIdClassConfig() {
            return (IdClassConfig)this._config;
        }

        public PostLoadConfig getPostLoadConfig() {
            return (PostLoadConfig)this._config;
        }

        public PrePersistConfig getPrePersistConfig() {
            return (PrePersistConfig)this._config;
        }

        public PostPersistConfig getPostPersistConfig() {
            return (PostPersistConfig)this._config;
        }

        public PreUpdateConfig getPreUpdateConfig() {
            return (PreUpdateConfig)this._config;
        }

        public PostUpdateConfig getPostUpdateConfig() {
            return (PostUpdateConfig)this._config;
        }

        public PreRemoveConfig getPreRemoveConfig() {
            return (PreRemoveConfig)this._config;
        }

        public PostRemoveConfig getPostRemoveConfig() {
            return (PostRemoveConfig)this._config;
        }

        public InheritanceConfig getInheritanceConfig() {
            return (InheritanceConfig)this._config;
        }

        public NamedQueryConfig getNamedQueryConfig() {
            return (NamedQueryConfig)this._config;
        }

        public NamedNativeQueryConfig getNamedNativeQueryConfig() {
            return (NamedNativeQueryConfig)this._config;
        }

        public SqlResultSetMappingConfig getSqlResultSetMappingConfig() {
            return (SqlResultSetMappingConfig)this._config;
        }

        public PrimaryKeyJoinColumnConfig getPrimaryKeyJoinColumnConfig() {
            return (PrimaryKeyJoinColumnConfig)this._config;
        }

        public DiscriminatorColumnConfig getDiscriminatorColumnConfig() {
            return (DiscriminatorColumnConfig)this._config;
        }

        public IdConfig getIdConfig() {
            return (IdConfig)this._config;
        }

        public EmbeddedIdConfig getEmbeddedIdConfig() {
            return (EmbeddedIdConfig)this._config;
        }

        public ColumnConfig getColumnConfig() {
            return (ColumnConfig)this._config;
        }

        public GeneratedValueConfig getGeneratedValueConfig() {
            return (GeneratedValueConfig)this._config;
        }

        public BasicConfig getBasicConfig() {
            return (BasicConfig)this._config;
        }

        public VersionConfig getVersionConfig() {
            return (VersionConfig)this._config;
        }

        public ManyToOneConfig getManyToOneConfig() {
            return (ManyToOneConfig)this._config;
        }

        public OneToOneConfig getOneToOneConfig() {
            return (OneToOneConfig)this._config;
        }

        public ManyToManyConfig getManyToManyConfig() {
            return (ManyToManyConfig)this._config;
        }

        public OneToManyConfig getOneToManyConfig() {
            return (OneToManyConfig)this._config;
        }

        public MapKeyConfig getMapKeyConfig() {
            return (MapKeyConfig)this._config;
        }

        public JoinTableConfig getJoinTableConfig() {
            return (JoinTableConfig)this._config;
        }

        public JoinColumnConfig getJoinColumnConfig() {
            return (JoinColumnConfig)this._config;
        }

        public AttributeOverrideConfig getAttributeOverrideConfig() {
            return (AttributeOverrideConfig)this._config;
        }

        public AssociationOverrideConfig getAssociationOverrideConfig() {
            return (AssociationOverrideConfig)this._config;
        }
    }
}

