/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.collection;

import com.caucho.amber.AmberQuery;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.collection.AmberCollection;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.UserQuery;
import com.caucho.util.CurrentTime;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionImpl<E>
extends AbstractList<E>
implements AmberCollection {
    private transient AmberQuery _query;
    private transient AmberConnection _aConn;
    private ArrayList<E> _values = new ArrayList();
    private transient long _expireTime;

    public CollectionImpl(AmberConnection aConn, String query) {
        this._aConn = aConn;
        if (query != null) {
            try {
                this._query = this._aConn.prepareQuery(query);
            }
            catch (SQLException e) {
                throw new AmberRuntimeException(e);
            }
        }
    }

    public CollectionImpl(AmberQuery query) {
        this._query = query;
        if (this._query != null) {
            this.setSession(((UserQuery)this._query).getConnection());
        }
    }

    public void setSession(AmberConnection aConn) {
        this._aConn = aConn;
        if (this._aConn != null) {
            this._aConn.register(this);
        }
    }

    public AmberConnection getSession() {
        return this._aConn;
    }

    public AmberQuery getQuery() {
        return this._query;
    }

    @Override
    public int size() {
        this.fill();
        return this._values.size();
    }

    @Override
    public Iterator<E> iterator() {
        this.fill();
        return new ValuesIterator(this._values);
    }

    @Override
    public E get(int index) {
        this.fill();
        return this._values.get(index);
    }

    @Override
    public boolean add(E o) {
        this.fill();
        return this._values.add(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        this.fill();
        if (collection == null) {
            return true;
        }
        return this._values.addAll(index, collection);
    }

    @Override
    public void clear() {
        this._values.clear();
        this._expireTime = CurrentTime.getCurrentTime();
    }

    @Override
    public void update() {
        this._expireTime = 0L;
    }

    protected boolean isValid() {
        return CurrentTime.getCurrentTime() <= this._expireTime;
    }

    public void detach() {
        this._aConn = null;
        this._query = null;
    }

    private void fill() {
        if (this._query == null) {
            return;
        }
        if (this._aConn == null) {
            return;
        }
        if (CurrentTime.getCurrentTime() <= this._expireTime) {
            return;
        }
        try {
            this._expireTime = CurrentTime.getCurrentTime();
            ((UserQuery)this._query).setSession(this._aConn);
            this._values.clear();
            this._query.list(this._values);
        }
        catch (SQLException e) {
            throw new AmberRuntimeException(e);
        }
    }

    private Object writeReplace() {
        return this._values;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ValuesIterator
    implements Iterator {
        private ArrayList<E> _values;
        private int i = 0;

        ValuesIterator(ArrayList<E> values) {
            this._values = new ArrayList(values);
        }

        @Override
        public boolean hasNext() {
            return this.i < this._values.size();
        }

        @Override
        public E next() {
            if (this.i < this._values.size()) {
                return this._values.get(this.i++);
            }
            return null;
        }

        @Override
        public void remove() {
            CollectionImpl.this.remove(this._values.get(this.i - 1));
        }
    }
}

