/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr.fun;

import com.caucho.amber.expr.AbstractAmberExpr;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.IdExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.type.AmberType;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunExpr
extends AbstractAmberExpr {
    private static final L10N L = new L10N(FunExpr.class);
    QueryParser _parser;
    String _id;
    ArrayList<AmberExpr> _args;
    boolean _distinct;

    protected FunExpr(QueryParser parser, String id, ArrayList<AmberExpr> args, boolean distinct) {
        this._parser = parser;
        this._id = id;
        this._args = args;
        this._distinct = distinct;
    }

    public static FunExpr create(QueryParser parser, String id, ArrayList<AmberExpr> args, boolean distinct) {
        return new FunExpr(parser, id, args, distinct);
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        for (int i = 0; i < this._args.size(); ++i) {
            AmberExpr arg = this._args.get(i);
            arg = arg.bindSelect(parser);
            this._args.set(i, arg);
        }
        return this;
    }

    @Override
    public AmberType getType() {
        if (this.getArgs().size() == 0) {
            return super.getType();
        }
        return this.getArgs().get(0).getType();
    }

    @Override
    public boolean usesFrom(FromItem from, int type, boolean isNot) {
        for (int i = 0; i < this._args.size(); ++i) {
            KeyColumnExpr key;
            IdExpr id;
            AmberExpr arg = this._args.get(i);
            if (arg instanceof IdExpr && (id = (IdExpr)arg).getFromItem() == from) {
                return true;
            }
            if (arg instanceof KeyColumnExpr && (key = (KeyColumnExpr)arg).usesFrom(from, 1, false)) {
                return true;
            }
            if (!arg.usesFrom(from, type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    @Override
    public void generateHaving(CharBuffer cb) {
        this.generateWhere(cb);
    }

    @Override
    public Object getObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        if (this._id.equalsIgnoreCase("count")) {
            return rs.getLong(index);
        }
        if (this._id.equalsIgnoreCase("avg")) {
            return rs.getDouble(index);
        }
        if (this._id.equalsIgnoreCase("size")) {
            return rs.getInt(index);
        }
        return super.getObject(aConn, rs, index);
    }

    public String toString() {
        String str = this._id + "(";
        if (this._distinct) {
            str = str + "distinct ";
        }
        for (int i = 0; i < this._args.size(); ++i) {
            if (i != 0) {
                str = str + ',';
            }
            str = str + this._args.get(i);
        }
        return str + ")";
    }

    public ArrayList<AmberExpr> getArgs() {
        return this._args;
    }

    private void generateInternalWhere(CharBuffer cb, boolean select) {
        cb.append(this._id);
        cb.append('(');
        if (this._distinct) {
            cb.append("distinct ");
        }
        for (int i = 0; i < this._args.size(); ++i) {
            if (i != 0) {
                cb.append(',');
            }
            if (select) {
                this._args.get(i).generateWhere(cb);
                continue;
            }
            this._args.get(i).generateUpdateWhere(cb);
        }
        cb.append(')');
    }
}

