/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr.fun;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.fun.FunExpr;
import com.caucho.amber.query.QueryParser;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimFunExpr
extends FunExpr {
    private static final L10N L = new L10N(TrimFunExpr.class);
    private TrimSemantics _trimSemantics = TrimSemantics.BOTH;
    private AmberExpr _trimChar;

    protected TrimFunExpr(QueryParser parser, ArrayList<AmberExpr> args) {
        super(parser, "trim", args, false);
    }

    public static TrimFunExpr create(QueryParser parser, ArrayList<AmberExpr> args) {
        return new TrimFunExpr(parser, args);
    }

    public void setTrimChar(AmberExpr trimChar) {
        this._trimChar = trimChar;
    }

    public void setTrimSemantics(TrimSemantics trimSemantics) {
        this._trimSemantics = trimSemantics;
    }

    @Override
    public void generateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, true);
    }

    @Override
    public void generateUpdateWhere(CharBuffer cb) {
        this.generateInternalWhere(cb, false);
    }

    void generateInternalWhere(CharBuffer cb, boolean select) {
        ArrayList<AmberExpr> args = this.getArgs();
        int n = args.size();
        if (this._parser.isDerbyDBMS()) {
            switch (this._trimSemantics) {
                case LEADING: {
                    cb.append("ltrim(");
                    break;
                }
                case TRAILING: {
                    cb.append("rtrim(");
                    break;
                }
                default: {
                    cb.append("ltrim(rtrim(");
                }
            }
            if (this._trimChar != null) {
                if (select) {
                    this._trimChar.generateWhere(cb);
                } else {
                    this._trimChar.generateUpdateWhere(cb);
                }
                cb.append(" from ");
            }
            if (select) {
                args.get(0).generateWhere(cb);
            } else {
                args.get(0).generateUpdateWhere(cb);
            }
            cb.append(')');
            if (this._trimSemantics == TrimSemantics.BOTH) {
                cb.append(')');
            }
            return;
        }
        cb.append("trim(");
        switch (this._trimSemantics) {
            case LEADING: {
                cb.append("leading ");
                break;
            }
            case TRAILING: {
                cb.append("trailing ");
                break;
            }
            default: {
                cb.append("both ");
            }
        }
        if (this._trimChar != null) {
            if (select) {
                this._trimChar.generateWhere(cb);
            } else {
                this._trimChar.generateUpdateWhere(cb);
            }
        }
        cb.append(" from ");
        if (select) {
            args.get(0).generateWhere(cb);
        } else {
            args.get(0).generateUpdateWhere(cb);
        }
        cb.append(")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TrimSemantics {
        LEADING,
        TRAILING,
        BOTH;

    }
}

