/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.CascadableField;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.logging.Logger;
import javax.persistence.CascadeType;

public class CollectionField
extends CascadableField {
    private static final L10N L = new L10N(CollectionField.class);
    private static final Logger log = Logger.getLogger(CollectionField.class.getName());
    private AmberType _targetType;
    private LinkColumns _linkColumns;
    private String _table;

    public CollectionField(EntityType relatedType, String name, CascadeType[] cascadeTypes) throws ConfigException {
        super(relatedType, name, cascadeTypes);
    }

    public CollectionField(EntityType relatedType) {
        super(relatedType);
    }

    public void setTable(String table) {
        this._table = table;
    }

    public String getTableName() {
        return this._table;
    }

    public void setType(AmberType targetType) {
        this._targetType = targetType;
    }

    public AmberType getTargetType() {
        return this._targetType;
    }

    public void setLinkColumns(LinkColumns linkColumns) {
        this._linkColumns = linkColumns;
    }

    public LinkColumns getLinkColumns() {
        return this._linkColumns;
    }

    public void generatePreCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
        if (this.isCascade(cascadeType)) {
            String getter = "_caucho_field_" + this.getGetterName();
            out.println("if (" + getter + " != null) {");
            out.pushDepth();
            out.println("for (Object o : " + getter + ") {");
            out.pushDepth();
            if (cascadeType == CascadeType.REMOVE) {
                out.println("com.caucho.amber.entity.Entity child = (com.caucho.amber.entity.Entity) o;");
                out.println();
                out.println("if (! child.__caucho_getEntityState().isTransactional())");
                out.println("  continue;");
                out.println();
            }
            out.print(aConn + ".");
            switch (cascadeType) {
                case PERSIST: {
                    out.print("persistFromCascade");
                    break;
                }
                case MERGE: {
                    out.print("merge");
                    break;
                }
                case REMOVE: {
                    out.print("remove");
                    break;
                }
                case REFRESH: {
                    out.print("refresh");
                }
            }
            out.println("(o);");
            out.popDepth();
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }

    public void generatePostCascade(JavaWriter out, String aConn, CascadeType cascadeType) throws IOException {
    }

    public void generateStatementSet(JavaWriter out, String pstmt, String obj, String index) throws IOException {
    }

    public void generateUpdate(JavaWriter out, String mask, String pstmt, String index) throws IOException {
        String maskVar = mask + "_" + this.getIndex() / 64;
        long maskValue = 1L << this.getIndex() % 64;
        out.println();
        out.println("if ((" + maskVar + " & " + maskValue + "L) != 0) {");
        out.pushDepth();
        this.generateStatementSet(out, pstmt, index);
        out.popDepth();
        out.println("}");
    }

    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    public String generateTargetSelect(String id) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public AmberExpr createExpr(QueryParser parser, PathExpr parent) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String generateJoin(String sourceTable, String targetTable) {
        return this._linkColumns.generateJoin(sourceTable, targetTable);
    }

    public ForeignColumn getSourceColumn(AmberColumn key) {
        return this._linkColumns.getSourceColumn(key);
    }
}

