/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.config.inject.HandleAware;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagerProxy
implements EntityManager,
Serializable,
HandleAware {
    private static final L10N L = new L10N(EntityManagerProxy.class);
    private static final Logger log = Logger.getLogger(EntityManagerProxy.class.getName());
    private AmberPersistenceUnit _persistenceUnit;
    private boolean _isExtended;
    private Object _serializationHandle;

    public EntityManagerProxy(AmberPersistenceUnit persistenceUnit) {
        this._persistenceUnit = persistenceUnit;
    }

    @Override
    public void persist(Object entity) {
        this.getCurrent().persist(entity);
    }

    @Override
    public <T> T merge(T entity) {
        return this.getCurrent().merge(entity);
    }

    @Override
    public void remove(Object entity) {
        this.getCurrent().remove(entity);
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return this.getCurrent().find(entityClass, primaryKey);
    }

    @Override
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return this.getCurrent().getReference(entityClass, primaryKey);
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.getCurrent().getFlushMode();
    }

    @Override
    public void setFlushMode(FlushModeType mode) {
        this.getCurrent().setFlushMode(mode);
    }

    public void setExtended(boolean isExtended) {
        this._isExtended = isExtended;
        this.getCurrent().setExtended(isExtended);
    }

    @Override
    public void lock(Object entity, LockModeType lockMode) {
        this.getCurrent().lock(entity, lockMode);
    }

    @Override
    public void clear() {
        this.getCurrent().clear();
    }

    @Override
    public void flush() {
        this.getCurrent().flush();
    }

    @Override
    public void joinTransaction() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getDelegate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() {
        throw new IllegalStateException(L.l("Container-manager persistence context may not be closed."));
    }

    @Override
    public Query createQuery(String sql) {
        return this.getCurrent().createQuery(sql);
    }

    @Override
    public Query createNamedQuery(String sql) {
        return this.getCurrent().createNamedQuery(sql);
    }

    @Override
    public Query createNativeQuery(String sql) {
        return this.getCurrent().createNativeQuery(sql);
    }

    @Override
    public Query createNativeQuery(String sql, String map) {
        return this.getCurrent().createNativeQuery(sql, map);
    }

    @Override
    public Query createNativeQuery(String sql, Class retType) {
        return this.getCurrent().createNativeQuery(sql, retType);
    }

    @Override
    public void refresh(Object entity) {
        this.getCurrent().refresh(entity);
    }

    @Override
    public boolean contains(Object entity) {
        return this.getCurrent().contains(entity);
    }

    @Override
    public EntityTransaction getTransaction() {
        return this.getCurrent().getTransaction();
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    private AmberConnection getCurrent() {
        return this._persistenceUnit.getThreadConnection(this._isExtended);
    }

    @Override
    public void setSerializationHandle(Object handle) {
        this._serializationHandle = handle;
    }

    private Object writeReplace() {
        return this._serializationHandle;
    }

    public String toString() {
        AmberConnection aConn = this.getCurrent();
        if (aConn != null) {
            return "EntityManagerProxy[" + aConn.getPersistenceUnit().getName() + "]";
        }
        return "EntityManagerProxy[closed]";
    }

    @Override
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return null;
    }

    @Override
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return null;
    }

    @Override
    public <T> TypedQuery<T> createQuery(String criteriaQuery, Class<T> resultClass) {
        return null;
    }

    @Override
    public void detach(Object entity) {
    }

    @Override
    public <T> T find(Class<T> entityCLass, Object primaryKey, Map<String, Object> properties) {
        return null;
    }

    @Override
    public <T> T find(Class<T> entityCLass, Object primaryKey, LockModeType lockMode) {
        return null;
    }

    @Override
    public <T> T find(Class<T> entityCLass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return null;
    }

    @Override
    public CriteriaBuilder getCriteriaBuilder() {
        return null;
    }

    @Override
    public EntityManagerFactory getEntityManagerFactory() {
        return null;
    }

    @Override
    public LockModeType getLockMode(Object entity) {
        return null;
    }

    @Override
    public Metamodel getMetamodel() {
        return null;
    }

    @Override
    public Map<String, Object> getProperties() {
        return null;
    }

    @Override
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
    }

    @Override
    public void refresh(Object entity, Map<String, Object> properties) {
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode) {
    }

    @Override
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
    }

    @Override
    public void setProperty(String propertyName, Object value) {
    }

    @Override
    public <T> T unwrap(Class<T> cls) {
        return null;
    }
}

