/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.expr.KeyColumnExpr;
import com.caucho.amber.expr.LoadEntityExpr;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.util.CharBuffer;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmberSelectQuery
extends AbstractQuery {
    private AbstractQuery _parentQuery;
    private boolean _isDistinct;
    private ArrayList<AmberExpr> _resultList;
    private ArrayList<AmberExpr> _orderList;
    private ArrayList<Boolean> _ascList;
    private ArrayList<AmberExpr> _groupList;
    private int _offset = -1;
    private int _limit = -1;
    private Map<AmberExpr, String> _joinFetchMap;
    private String _sql;
    private Class _constructorClass;
    private boolean _isTableReadOnly = false;
    private long _cacheTimeout = -1L;
    private boolean _hasFrom = true;

    AmberSelectQuery(String query, JdbcMetaData metaData) {
        super(query, metaData);
    }

    Map<AmberExpr, String> getJoinFetchMap() {
        return this._joinFetchMap;
    }

    void setConstructorClass(Class cl) {
        this._constructorClass = cl;
    }

    public Class getConstructorClass() {
        return this._constructorClass;
    }

    void setHasFrom(boolean hasFrom) {
        this._hasFrom = hasFrom;
    }

    void setParentQuery(AbstractQuery parent) {
        this._parentQuery = parent;
        if (parent != null) {
            parent.setHasSubQuery(true);
        }
    }

    @Override
    public AbstractQuery getParentQuery() {
        return this._parentQuery;
    }

    void setDistinct(boolean isDistinct) {
        this._isDistinct = isDistinct;
    }

    void setResultList(ArrayList<AmberExpr> resultList) {
        this._resultList = resultList;
    }

    public ArrayList<AmberExpr> getResultList() {
        return this._resultList;
    }

    int getResultCount() {
        return this._resultList.size();
    }

    AmberType getResultType(int index) {
        AmberExpr expr = this._resultList.get(index);
        return expr.getType();
    }

    void setHaving(AmberExpr expr) {
        this._having = expr;
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    void setGroupList(ArrayList<AmberExpr> groupList) {
        this._groupList = groupList;
    }

    void setJoinFetchMap(Map<AmberExpr, String> joinFetchMap) {
        this._joinFetchMap = joinFetchMap;
    }

    void setOrderList(ArrayList<AmberExpr> orderList, ArrayList<Boolean> ascList) {
        this._orderList = orderList;
        this._ascList = ascList;
    }

    @Override
    public String getSQL() {
        return this._sql;
    }

    @Override
    public long getCacheMaxAge() {
        return this._cacheTimeout;
    }

    public boolean isCacheable() {
        return 100L <= this._cacheTimeout;
    }

    public boolean isTableReadOnly() {
        return this._isTableReadOnly;
    }

    public void setOffset(int offset) {
        this._offset = offset;
    }

    public int getOffset() {
        return this._offset;
    }

    public void setLimit(int limit) {
        this._limit = limit;
    }

    public int getLimit() {
        return this._limit;
    }

    @Override
    void init() throws QueryParseException {
        super.init();
        this._cacheTimeout = 0x3FFFFFFFFFFFFFFFL;
        this._isTableReadOnly = true;
        for (FromItem item : this._fromList) {
            EntityType type = item.getTableType();
            if (type != null) {
                long timeout = type.getCacheTimeout();
                if (timeout < this._cacheTimeout) {
                    this._cacheTimeout = timeout;
                }
                if (type.isReadOnly()) continue;
                this._isTableReadOnly = false;
                continue;
            }
            this._isTableReadOnly = false;
        }
        this._sql = this.generateLoadSQL();
    }

    @Override
    public boolean exists(FromItem item) {
        if (this._where != null && this._where.exists(item)) {
            return true;
        }
        if (this._orderList != null) {
            for (AmberExpr orderBy : this._orderList) {
                if (!(orderBy instanceof KeyColumnExpr) || !orderBy.usesFrom(item, 1, false)) continue;
                return true;
            }
        }
        if (this._groupList != null) {
            for (AmberExpr groupBy : this._groupList) {
                if (!(groupBy instanceof KeyColumnExpr) || !groupBy.usesFrom(item, 1, false)) continue;
                return true;
            }
        }
        return this._having != null && this._having.exists(item);
    }

    @Override
    public boolean usesFrom(FromItem item, int type) {
        int j;
        for (j = 0; j < this._resultList.size(); ++j) {
            AmberExpr result = this._resultList.get(j);
            if (!result.usesFrom(item, type)) continue;
            return true;
        }
        if (this._where != null && this._where.usesFrom(item, type)) {
            return true;
        }
        if (this._orderList != null) {
            for (j = 0; j < this._orderList.size(); ++j) {
                AmberExpr order = this._orderList.get(j);
                if (!order.usesFrom(item, type)) continue;
                return true;
            }
        }
        if (this._groupList != null) {
            for (j = 0; j < this._groupList.size(); ++j) {
                AmberExpr group = this._groupList.get(j);
                if (!group.usesFrom(item, 1)) continue;
                return true;
            }
            if (this._having != null && this._having.usesFrom(item, type)) {
                return true;
            }
        }
        return false;
    }

    @Override
    void replaceJoin(JoinExpr join) {
        int i;
        for (i = 0; i < this._resultList.size(); ++i) {
            AmberExpr result = this._resultList.get(i);
            this._resultList.set(i, result.replaceJoin(join));
        }
        if (this._where != null) {
            this._where = this._where.replaceJoin(join);
        }
        if (this._orderList != null) {
            for (i = 0; i < this._orderList.size(); ++i) {
                AmberExpr order = this._orderList.get(i);
                this._orderList.set(i, order.replaceJoin(join));
            }
        }
    }

    public String generateLoadSQL() {
        return this.generateLoadSQL(true);
    }

    public String generateLoadSQL(boolean fullSelect) {
        int i;
        int i2;
        CharBuffer cb = CharBuffer.allocate();
        cb.append("select ");
        if (this._isDistinct) {
            cb.append(" distinct ");
        }
        for (i2 = 0; i2 < this._resultList.size(); ++i2) {
            if (i2 != 0) {
                cb.append(", ");
            }
            AmberExpr expr = this._resultList.get(i2);
            if (this._groupList == null && expr instanceof LoadEntityExpr) {
                ((LoadEntityExpr)expr).generateSelect(cb, fullSelect);
                continue;
            }
            expr.generateSelect(cb);
        }
        if (this._hasFrom) {
            cb.append(" from ");
        }
        for (i2 = 1; i2 < this._fromList.size(); ++i2) {
            FromItem parent;
            int index;
            JoinExpr join;
            FromItem item = (FromItem)this._fromList.get(i2);
            if (!item.isOuterJoin() || (join = item.getJoinExpr()) == null || (index = this._fromList.indexOf(parent = join.getJoinParent())) < 0) continue;
            this._fromList.remove(i2);
            if (index < i2) {
                ++index;
            }
            this._fromList.add(index, item);
        }
        boolean hasJoinExpr = false;
        boolean isFirst = true;
        for (int i3 = 0; i3 < this._fromList.size(); ++i3) {
            ArrayList<FromItem> fromList;
            FromItem item = (FromItem)this._fromList.get(i3);
            if (this.getParentQuery() != null && (fromList = this.getParentQuery().getFromList()) != null && fromList.contains(item)) {
                hasJoinExpr = true;
                continue;
            }
            if (isFirst) {
                isFirst = false;
            } else if (item.isOuterJoin()) {
                cb.append(" left outer join ");
            } else {
                cb.append(", ");
                if (item.getJoinExpr() != null) {
                    hasJoinExpr = true;
                }
            }
            cb.append(item.getTable().getName());
            cb.append(" ");
            cb.append(item.getName());
            if (item.getJoinExpr() != null && item.isOuterJoin()) {
                cb.append(" on ");
                item.getJoinExpr().generateJoin(cb);
            }
            EntityType entityType = item.getEntityType();
        }
        boolean hasExpr = false;
        for (i = 0; i < this._fromList.size(); ++i) {
            EntityType entityType;
            FromItem item = (FromItem)this._fromList.get(i);
            JoinExpr expr = item.getJoinExpr();
            if (expr != null && !item.isOuterJoin()) {
                if (hasExpr) {
                    cb.append(" and ");
                } else {
                    cb.append(" where ");
                    hasExpr = true;
                }
                expr.generateJoin(cb);
            }
            if ((entityType = item.getEntityType()) == null) continue;
            AmberColumn discriminator = entityType.getDiscriminator();
            if (!(entityType instanceof SubEntityType) || discriminator == null || item.getTable() != discriminator.getTable()) continue;
            if (hasExpr) {
                cb.append(" and ");
            } else {
                cb.append(" where ");
                hasExpr = true;
            }
            cb.append("(" + item.getName() + "." + discriminator.getName() + " = ");
            cb.append("'" + entityType.getDiscriminatorValue() + "')");
        }
        if (this._where != null) {
            if (hasExpr) {
                cb.append(" and ");
            } else {
                cb.append(" where ");
                hasExpr = true;
            }
            this._where.generateWhere(cb);
        }
        if (this._groupList != null) {
            cb.append(" group by ");
            for (i = 0; i < this._groupList.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                this._groupList.get(i).generateSelect(cb);
            }
        }
        if (this._having != null) {
            hasExpr = false;
            cb.append(" having ");
            if (this._having != null) {
                if (hasExpr) {
                    cb.append(" and ");
                }
                hasExpr = true;
                this._having.generateHaving(cb);
            }
        }
        if (this._orderList != null) {
            cb.append(" order by ");
            for (i = 0; i < this._orderList.size(); ++i) {
                if (i != 0) {
                    cb.append(", ");
                }
                this._orderList.get(i).generateSelect(cb);
                if (!Boolean.FALSE.equals(this._ascList.get(i))) continue;
                cb.append(" desc");
            }
        }
        return cb.toString();
    }

    public boolean invalidateTable(String table) {
        for (int i = this._fromList.size() - 1; i >= 0; --i) {
            FromItem from = (FromItem)this._fromList.get(i);
            if (!table.equals(from.getTable().getName())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SelectQuery[" + this.getQueryString() + "]";
    }
}

