/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.query;

import com.caucho.amber.entity.TableInvalidateCompletion;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.JoinExpr;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParseException;
import com.caucho.amber.query.UserQuery;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.jdbc.PostgresMetaData;
import com.caucho.util.CharBuffer;
import java.sql.SQLException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateQuery
extends AbstractQuery {
    private ArrayList<AmberExpr> _fieldList;
    private ArrayList<AmberExpr> _valueList;
    private String _sql;

    UpdateQuery(String query, JdbcMetaData metaData) {
        super(query, metaData);
    }

    void setFieldList(ArrayList<AmberExpr> fieldList) {
        this._fieldList = fieldList;
    }

    public ArrayList<AmberExpr> getFieldList() {
        return this._fieldList;
    }

    void setValueList(ArrayList<AmberExpr> exprList) {
        this._valueList = exprList;
    }

    public ArrayList<AmberExpr> getValueList() {
        return this._valueList;
    }

    void setWhere(AmberExpr expr) {
        this._where = expr;
    }

    @Override
    public String getSQL() {
        return this._sql;
    }

    @Override
    void init() throws QueryParseException {
        super.init();
        CharBuffer cb = new CharBuffer();
        cb.append("update ");
        FromItem item = (FromItem)this._fromList.get(0);
        if (this.getMetaData().supportsUpdateTableAlias() && this._fromList.size() > 1) {
            if (this.getMetaData().supportsUpdateTableList()) {
                this.generateFromList(cb, false);
            } else {
                cb.append(item.getTable().getName());
                cb.append(" ");
                cb.append(item.getName());
            }
        } else {
            cb.append(item.getTable().getName());
        }
        cb.append(" set ");
        for (int i = 0; i < this._fieldList.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            AmberExpr expr = this._fieldList.get(i);
            if (this.getMetaData().supportsUpdateTableAlias() && this._fromList.size() > 1) {
                expr.generateWhere(cb);
            } else {
                expr.generateUpdateWhere(cb);
            }
            cb.append("=");
            if (this.getMetaData().supportsUpdateTableAlias() || this.hasSubQuery()) {
                this._valueList.get(i).generateWhere(cb);
                continue;
            }
            this._valueList.get(i).generateUpdateWhere(cb);
        }
        Object updateJoin = null;
        if (this._where != null) {
            if (this._fromList.size() == 1 && !this.hasSubQuery()) {
                cb.append(" where ");
                this._where.generateUpdateWhere(cb);
            } else {
                EntityType type;
                boolean isFirst = true;
                if (this.getMetaData() instanceof PostgresMetaData) {
                    item = (FromItem)this._fromList.get(0);
                    type = item.getEntityType();
                    String targetId = type.getId().generateSelect(item.getName());
                    cb.append(" FROM ");
                    String tableName = item.getTable().getName();
                    cb.append(tableName);
                    cb.append(' ');
                    cb.append(item.getName());
                    isFirst = false;
                    cb.append(" where ");
                    cb.append(targetId);
                    cb.append(" = ");
                    cb.append(type.getId().generateSelect(item.getTable().getName()));
                }
                if (this._fromList.size() > 1 && !this.getMetaData().supportsUpdateTableList()) {
                    item = (FromItem)this._fromList.get(1);
                    type = item.getEntityType();
                    String relatedId = type.getId().generateSelect(item.getName());
                    if (isFirst) {
                        isFirst = false;
                        cb.append(" where ");
                    } else {
                        cb.append(" and ");
                    }
                    cb.append("exists (select ");
                    cb.append(relatedId);
                    cb.append(" from ");
                    this.generateFromList(cb, true);
                    isFirst = true;
                }
                for (int i = 0; i < this._fromList.size(); ++i) {
                    EntityType entityType;
                    item = (FromItem)this._fromList.get(i);
                    JoinExpr expr = item.getJoinExpr();
                    if (expr != null && !item.isOuterJoin()) {
                        if (isFirst) {
                            isFirst = false;
                            cb.append(" where ");
                        } else {
                            cb.append(" and ");
                        }
                        expr.generateJoin(cb);
                    }
                    if ((entityType = item.getEntityType()) == null) continue;
                    AmberColumn discriminator = entityType.getDiscriminator();
                    if (!(entityType instanceof SubEntityType) || discriminator == null || item.getTable() != discriminator.getTable()) continue;
                    if (isFirst) {
                        isFirst = false;
                        cb.append(" where ");
                    } else {
                        cb.append(" and ");
                    }
                    cb.append("(" + item.getName() + "." + discriminator.getName() + " = ");
                    cb.append("'" + entityType.getDiscriminatorValue() + "')");
                }
                if (isFirst) {
                    isFirst = false;
                    cb.append(" where ");
                } else {
                    cb.append(" and ");
                }
                this._where.generateWhere(cb);
            }
        }
        if (this._fromList.size() > 1 && !this.getMetaData().supportsUpdateTableList()) {
            cb.append(")");
        }
        this._sql = cb.close();
    }

    @Override
    public void prepare(UserQuery userQuery, AmberConnection aConn) throws SQLException {
        aConn.flushNoChecks();
    }

    @Override
    public void complete(UserQuery userQuery, AmberConnection aConn) throws SQLException {
        aConn.expire();
        FromItem item = (FromItem)this._fromList.get(0);
        aConn.addCompletion(new TableInvalidateCompletion(item.getEntityType().getTable().getName()));
    }

    public String toString() {
        return "UpdateQuery[" + this.getQueryString() + "]";
    }

    private void generateFromList(CharBuffer cb, boolean skipFirst) {
        FromItem item;
        for (int i = 1; i < this._fromList.size(); ++i) {
            FromItem parent;
            int index;
            JoinExpr join;
            item = (FromItem)this._fromList.get(i);
            if (!item.isOuterJoin() || (join = item.getJoinExpr()) == null || (index = this._fromList.indexOf(parent = join.getJoinParent())) < 0) continue;
            this._fromList.remove(i);
            if (index < i) {
                ++index;
            }
            this._fromList.add(index, item);
        }
        boolean hasJoinExpr = false;
        boolean isFirst = true;
        int i = 0;
        if (skipFirst) {
            ++i;
        }
        while (i < this._fromList.size()) {
            ArrayList<FromItem> fromList;
            item = (FromItem)this._fromList.get(i);
            if (this.getParentQuery() != null && (fromList = this.getParentQuery().getFromList()) != null && fromList.contains(item)) {
                hasJoinExpr = true;
            } else {
                if (isFirst) {
                    isFirst = false;
                } else if (item.isOuterJoin()) {
                    cb.append(" left outer join ");
                } else {
                    cb.append(", ");
                    if (item.getJoinExpr() != null) {
                        hasJoinExpr = true;
                    }
                }
                cb.append(item.getTable().getName());
                cb.append(" ");
                cb.append(item.getName());
                if (item.getJoinExpr() != null && item.isOuterJoin()) {
                    cb.append(" on ");
                    item.getJoinExpr().generateJoin(cb);
                }
            }
            ++i;
        }
    }
}

