/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.table;

import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.ejb.EJBExceptionWrapper;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkColumns {
    private static final L10N L = new L10N(LinkColumns.class);
    private static final Logger log = Log.open(LinkColumns.class);
    private static final int NO_CASCADE_DELETE = 0;
    private static final int SOURCE_CASCADE_DELETE = 1;
    private static final int TARGET_CASCADE_DELETE = 2;
    private AmberTable _sourceTable;
    private AmberTable _targetTable;
    private ArrayList<ForeignColumn> _columns;
    private int _cascadeDelete;
    private AmberCompletion _tableDeleteCompletion;
    private AmberCompletion _tableUpdateCompletion;

    public LinkColumns(AmberTable sourceTable, AmberTable targetTable, ArrayList<ForeignColumn> columns) {
        this._sourceTable = sourceTable;
        this._targetTable = targetTable;
        this._columns = columns;
        this._tableDeleteCompletion = sourceTable.getDeleteCompletion();
        this._tableUpdateCompletion = sourceTable.getUpdateCompletion();
        this._sourceTable.addOutgoingLink(this);
        this._targetTable.addIncomingLink(this);
    }

    public void setSourceCascadeDelete(boolean isCascadeDelete) {
        if (isCascadeDelete) {
            assert (this._cascadeDelete != 2);
            this._cascadeDelete = 1;
        } else if (this._cascadeDelete == 1) {
            this._cascadeDelete = 0;
        }
    }

    public void setTargetCascadeDelete(boolean isCascadeDelete) {
        if (isCascadeDelete) {
            assert (this._cascadeDelete != 1);
            this._cascadeDelete = 2;
        } else if (this._cascadeDelete == 2) {
            this._cascadeDelete = 0;
        }
    }

    public boolean isSourceCascadeDelete() {
        return this._cascadeDelete == 1;
    }

    public boolean isTargetCascadeDelete() {
        return this._cascadeDelete == 2;
    }

    public AmberTable getSourceTable() {
        return this._sourceTable;
    }

    public AmberTable getTargetTable() {
        return this._targetTable;
    }

    public ArrayList<ForeignColumn> getColumns() {
        return this._columns;
    }

    public ForeignColumn getSourceColumn(AmberColumn targetKey) {
        for (int i = this._columns.size() - 1; i >= 0; --i) {
            ForeignColumn column = this._columns.get(i);
            if (column.getTargetColumn() != targetKey) continue;
            return column;
        }
        return null;
    }

    public String generateSelectSQL(String table) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            if (table != null) {
                cb.append(table);
                cb.append(".");
            }
            cb.append(this._columns.get(i).getName());
        }
        return cb.toString();
    }

    public void generateInsert(ArrayList<String> columns) {
        for (int i = 0; i < this._columns.size(); ++i) {
            columns.add(this._columns.get(i).getName());
        }
    }

    public String generateUpdateSQL() {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(", ");
            }
            cb.append(this._columns.get(i).getName() + "=?");
        }
        return cb.toString();
    }

    public String generateMatchArgSQL(String table) {
        CharBuffer cb = new CharBuffer();
        for (int i = 0; i < this._columns.size(); ++i) {
            if (i != 0) {
                cb.append(" and ");
            }
            if (table != null) {
                cb.append(table);
                cb.append(".");
            }
            cb.append(this._columns.get(i).getName());
            cb.append("=?");
        }
        return cb.toString();
    }

    public String generateJoin(String sourceTable, String targetTable) {
        return this.generateJoin(sourceTable, targetTable, false);
    }

    public String generateJoin(String sourceTable, String targetTable, boolean isArg) {
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._columns.size(); ++i) {
            ForeignColumn column = this._columns.get(i);
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(sourceTable);
            cb.append('.');
            cb.append(column.getName());
            cb.append(" = ");
            cb.append(targetTable);
            if (isArg) continue;
            cb.append('.');
            cb.append(column.getTargetColumn().getName());
        }
        cb.append(')');
        return cb.toString();
    }

    public String generateJoin(LinkColumns manyToOneJoin, String sourceTable1, String sourceTable2) {
        if (manyToOneJoin._columns.size() != this._columns.size()) {
            return "";
        }
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._columns.size(); ++i) {
            ForeignColumn column = this._columns.get(i);
            ForeignColumn otherColumn = manyToOneJoin._columns.get(i);
            if (i != 0) {
                cb.append(" and ");
            }
            cb.append(sourceTable1);
            cb.append('.');
            cb.append(column.getName());
            cb.append(" = ");
            cb.append(sourceTable2);
            cb.append('.');
            cb.append(otherColumn.getName());
        }
        cb.append(')');
        return cb.toString();
    }

    public String generateWhere(String sourceTable, String targetTable) {
        CharBuffer cb = new CharBuffer();
        cb.append('(');
        for (int i = 0; i < this._columns.size(); ++i) {
            ForeignColumn column = this._columns.get(i);
            if (i != 0) {
                cb.append(" and ");
            }
            if (!column.isNotNull()) {
                if (sourceTable == null) {
                    cb.append('?');
                } else {
                    cb.append(sourceTable);
                    cb.append('.');
                    cb.append(column.getName());
                }
                cb.append(" is not null ");
            }
            cb.append(" and ");
            if (sourceTable == null) {
                cb.append('?');
            } else {
                cb.append(sourceTable);
                cb.append('.');
                cb.append(column.getName());
            }
            cb.append(" = ");
            cb.append(targetTable);
            cb.append('.');
            cb.append(column.getTargetColumn().getName());
        }
        cb.append(')');
        return cb.toString();
    }

    public void beforeTargetDelete(AmberConnection aConn, Entity entity) throws SQLException {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = null;
        try {
            boolean isJPA;
            String sourceTable = this._sourceTable.getName();
            ArrayList<LinkColumns> outgoingLinks = this._sourceTable.getOutgoingLinks();
            boolean isOwner = false;
            if (outgoingLinks != null && outgoingLinks.size() > 0) {
                LinkColumns linkColumns = outgoingLinks.get(0);
                if (linkColumns._targetTable == entity.__caucho_getEntityType().getTable()) {
                    isOwner = true;
                }
            }
            if (!(isJPA = aConn.getPersistenceUnit().isJPA()) && !this.isSourceCascadeDelete()) {
                int i;
                CharBuffer cb = new CharBuffer();
                cb.append("update " + sourceTable + " set ");
                ArrayList<ForeignColumn> columns = this.getColumns();
                for (i = 0; i < columns.size(); ++i) {
                    if (i != 0) {
                        cb.append(", ");
                    }
                    cb.append(columns.get(i).getName() + "=null");
                }
                cb.append(" where ");
                for (i = 0; i < columns.size(); ++i) {
                    if (i != 0) {
                        cb.append(" and ");
                    }
                    cb.append(columns.get(i).getName() + "=?");
                }
                sql = cb.toString();
                pstmt = aConn.prepareStatement(sql);
                entity.__caucho_setKey(pstmt, 1);
                pstmt.executeUpdate();
                aConn.addCompletion(this._sourceTable.getUpdateCompletion());
            } else if (this._sourceTable.isCascadeDelete()) {
                EntityType entityType = this._sourceTable.getType();
                CharBuffer cb = new CharBuffer();
                cb.append("select ");
                cb.append(entityType.getId().generateSelect("o"));
                cb.append(" from " + sourceTable + " o");
                cb.append(" where ");
                ArrayList<ForeignColumn> columns = this.getColumns();
                for (int i = 0; i < columns.size(); ++i) {
                    if (i != 0) {
                        cb.append(" and ");
                    }
                    cb.append(columns.get(i).getName() + "=?");
                }
                sql = cb.toString();
                pstmt = aConn.prepareStatement(sql);
                entity.__caucho_setKey(pstmt, 1);
                ArrayList<Object> proxyList = new ArrayList<Object>();
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    proxyList.add(entityType.getHome().loadLazy(aConn, rs, 1));
                }
                rs.close();
                for (Object e : proxyList) {
                    entityType.getHome().getEntityFactory().delete(aConn, e);
                }
            } else if (!isJPA || isOwner && this._sourceTable.getType() == null) {
                CharBuffer cb = new CharBuffer();
                cb.append("delete from " + sourceTable + " where ");
                ArrayList<ForeignColumn> columns = this.getColumns();
                for (int i = 0; i < columns.size(); ++i) {
                    if (i != 0) {
                        cb.append(" and ");
                    }
                    cb.append(columns.get(i).getName() + "=?");
                }
                sql = cb.toString();
                pstmt = aConn.prepareStatement(sql);
                entity.__caucho_setKey(pstmt, 1);
                pstmt.executeUpdate();
                aConn.addCompletion(this._sourceTable.getDeleteCompletion());
            }
            aConn.expire();
        }
        catch (Exception e) {
            if (pstmt != null) {
                aConn.closeStatement(sql);
            }
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new EJBExceptionWrapper((Throwable)e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    public void afterSourceDelete(AmberConnection aConn, Entity entity) throws SQLException {
    }

    public String toString() {
        return "[" + this._sourceTable + ", " + this._targetTable + ", " + this._columns + "]";
    }
}

