/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.IntegerType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveIntType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveIntType.class);
    private static final PrimitiveIntType INT_TYPE = new PrimitiveIntType();

    private PrimitiveIntType() {
    }

    public static PrimitiveIntType create() {
        return INT_TYPE;
    }

    public String getName() {
        return "int";
    }

    public boolean isNumeric() {
        return true;
    }

    public AmberType getForeignType() {
        return IntegerType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(4, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getInt(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getInt(columnNames[" + index + "])");
        return index + 1;
    }

    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveIntType.toForeignInt(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setInt(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setInt(" + index + "++, " + value + " + 1);");
    }

    public String toObject(String value) {
        return "new Integer(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").intValue()";
    }

    public static Integer toForeignInt(int value, boolean wasNull) {
        if (wasNull || value == 0) {
            return null;
        }
        return new Integer(value);
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        int v = rs.getInt(index);
        return rs.wasNull() ? null : new Integer(v);
    }

    public Object toObject(long value) {
        return new Integer((int)value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

