/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.amber.type.ShortType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveShortType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveShortType.class);
    private static final PrimitiveShortType SHORT_TYPE = new PrimitiveShortType();

    private PrimitiveShortType() {
    }

    public static PrimitiveShortType create() {
        return SHORT_TYPE;
    }

    public String getName() {
        return "short";
    }

    public boolean isNumeric() {
        return true;
    }

    public AmberType getForeignType() {
        return ShortType.create();
    }

    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(5, length, precision, scale);
    }

    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getShort(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getShort(columnNames[" + index + "])");
        return index + 1;
    }

    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setShort(" + index + "++, " + value + ");");
    }

    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.SMALLINT);");
    }

    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setShort(" + index + "++, " + value + " + 1);");
    }

    public String toObject(String value) {
        return "new Short(" + value + ")";
    }

    public String generateCastFromObject(String value) {
        return "((Number) " + value + ").shortValue()";
    }

    public Object getObject(ResultSet rs, int index) throws SQLException {
        short v = rs.getShort(index);
        return rs.wasNull() ? null : new Short(v);
    }

    public Object toObject(long value) {
        return new Short((short)value);
    }

    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

