/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.impl;

import com.caucho.util.CurrentTime;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class AbstractActorWorker
implements Runnable {
    private static final Logger log = Logger.getLogger(AbstractActorWorker.class.getName());
    private static final int TASK_PARK = 0;
    private static final int TASK_SLEEP = 1;
    private static final int TASK_READY = 2;
    private static final AtomicLong _idGen = new AtomicLong();
    private final AtomicInteger _taskState = new AtomicInteger();
    private final AtomicBoolean _isActive = new AtomicBoolean();
    private final Executor _executor;
    private final ClassLoader _classLoader;
    private final String _name;
    private long _idleTimeoutNanos = 0L;
    private boolean _isClosed;
    private volatile Thread _thread;

    protected AbstractActorWorker(String name, Executor executor, ClassLoader classLoader) {
        this._name = name;
        this._executor = executor;
        this._classLoader = classLoader;
    }

    public final boolean isTaskActive() {
        return this._isActive.get();
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void setIdleTimeout(long idleTimeout, TimeUnit timeUnit) {
        this._idleTimeoutNanos = timeUnit.toNanos(idleTimeout);
    }

    public long getIdleTimeoutNanos() {
        return this._idleTimeoutNanos;
    }

    public String getName() {
        return this._name;
    }

    public abstract void runTask();

    public void close() {
        this._isClosed = true;
        this.wake();
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public final void wake() {
        Thread thread;
        int oldState = this._taskState.getAndSet(2);
        if (this._isActive.compareAndSet(false, true)) {
            this.startWorkerThread();
        }
        if (oldState == 0 && (thread = this._thread) != null) {
            this.unpark(thread);
        }
    }

    protected void startWorkerThread() {
        this._executor.execute(this);
    }

    protected void unpark(Thread thread) {
        LockSupport.unpark(thread);
    }

    protected String getThreadName() {
        return this.getName();
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        try {
            this._thread = thread;
            thread.setContextClassLoader(this._classLoader);
            thread.setName(this.getThreadName());
            this.onThreadStart();
            while (true) {
                if (this._taskState.getAndSet(1) == 2) {
                    thread.setContextClassLoader(this._classLoader);
                    this.runTask();
                    continue;
                }
                long idleTimeout = this.getIdleTimeoutNanos();
                if (this.isClosed()) {
                    return;
                }
                if (idleTimeout > 0L && this._taskState.compareAndSet(1, 0)) {
                    Thread.interrupted();
                    LockSupport.parkNanos(idleTimeout);
                }
                if (this._taskState.get() != 2) break;
            }
        }
        catch (Throwable e) {
            this.onException(e);
        }
        finally {
            this._thread = null;
            this._isActive.set(false);
            this.onThreadComplete();
            if (this._taskState.get() == 2) {
                this.wake();
            }
            thread.setName(oldName);
        }
    }

    protected void onException(Throwable e) {
        System.out.println("EXN: " + e);
        log.log(Level.WARNING, e.toString(), e);
    }

    protected long getCurrentTimeActual() {
        return CurrentTime.getCurrentTimeActual();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

