/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amp.skeleton;

import com.caucho.amp.AmpQueryCallback;
import com.caucho.amp.actor.AmpActorContext;
import com.caucho.amp.actor.AmpActorRef;
import com.caucho.amp.actor.AmpMethodRef;
import com.caucho.amp.actor.AmpQueryFuture;
import com.caucho.amp.stream.NullEncoder;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AmpReflectionHandler
implements InvocationHandler {
    private HashMap<Method, Call> _callMap = new HashMap();
    private AmpActorRef _to;
    private AmpActorContext _systemContext;
    private long _timeout = 60000L;

    AmpReflectionHandler(Class<?> api, AmpActorRef to, AmpActorContext systemContext) {
        this._to = to;
        this._systemContext = systemContext;
        if (systemContext == null) {
            throw new NullPointerException();
        }
        for (Method m : api.getMethods()) {
            if (m.getDeclaringClass() == Object.class) continue;
            AmpMethodRef methodRef = this._to.getMethod(m.getName(), NullEncoder.ENCODER);
            Call call = null;
            Class<?>[] param = m.getParameterTypes();
            call = param.length > 0 && AmpQueryCallback.class.isAssignableFrom(param[param.length - 1]) ? new QueryCallbackCall(methodRef, param.length - 1) : (Void.TYPE.equals(m.getReturnType()) ? new MessageCall(methodRef) : new QueryCall(methodRef));
            this._callMap.put(m, call);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int size;
        Call call = this._callMap.get(method);
        if (call != null) {
            return call.invoke(this._systemContext, this._to, args, this._timeout);
        }
        String name = method.getName();
        int n = size = args != null ? args.length : 0;
        if ("toString".equals(name) && size == 0) {
            return "BamProxyHandler[" + this._to + "]";
        }
        return null;
    }

    static class MessageCall
    extends Call {
        private final AmpMethodRef _methodRef;

        MessageCall(AmpMethodRef methodRef) {
            this._methodRef = methodRef;
        }

        Object invoke(AmpActorContext systemContext, AmpActorRef to, Object[] args, long timeout) {
            AmpActorContext context = AmpActorContext.getCurrent(systemContext);
            context.send(this._methodRef, args);
            return null;
        }
    }

    static class QueryCallbackCall
    extends Call {
        private final AmpMethodRef _methodRef;
        private final int _paramLen;

        QueryCallbackCall(AmpMethodRef methodRef, int paramLen) {
            this._methodRef = methodRef;
            this._paramLen = paramLen;
        }

        Object invoke(AmpActorContext systemContext, AmpActorRef to, Object[] args, long timeout) {
            Object[] param = new Object[args.length - 1];
            System.arraycopy(args, 0, param, 0, param.length);
            AmpQueryCallback cb = (AmpQueryCallback)args[this._paramLen];
            AmpActorContext context = AmpActorContext.getCurrent(systemContext);
            context.query(this._methodRef, args, cb, timeout);
            return null;
        }
    }

    static class QueryCall
    extends Call {
        private final AmpMethodRef _methodRef;

        QueryCall(AmpMethodRef methodRef) {
            this._methodRef = methodRef;
        }

        Object invoke(AmpActorContext systemContext, AmpActorRef to, Object[] args, long timeout) {
            AmpQueryFuture future = new AmpQueryFuture(timeout);
            AmpActorContext context = AmpActorContext.getCurrent(systemContext);
            context.query(this._methodRef, args, future, timeout);
            return future.get();
        }
    }

    static abstract class Call {
        Call() {
        }

        abstract Object invoke(AmpActorContext var1, AmpActorRef var2, Object[] var3, long var4);
    }
}

