/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.client;

import com.caucho.amqp.AmqpReceiver;
import com.caucho.amqp.client.AmqpClientConnectionImpl;
import com.caucho.amqp.client.AmqpClientReceiverFactory;
import com.caucho.amqp.client.AmqpClientReceiverLink;
import com.caucho.amqp.common.AmqpSession;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.marshal.AmqpMessageDecoder;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.message.common.AbstractMessageReceiver;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AmqpClientReceiver<T>
extends AbstractMessageReceiver<T>
implements AmqpReceiver<T> {
    private static final long TIMEOUT_INFINITY = 0x3FFFFFFFFFFFFFFFL;
    private final AmqpClientConnectionImpl _client;
    private final String _address;
    private final AmqpClientReceiverLink _link;
    private final SettleMode _settleMode;
    private int _prefetch;
    private final AmqpMessageDecoder<T> _decoder;
    private final Map<String, Object> _attachProperties;
    private final Map<String, Object> _sourceProperties;
    private final Map<String, Object> _targetProperties;
    private int _linkCredit;
    private LinkedBlockingQueue<ValueNode<T>> _valueQueue = new LinkedBlockingQueue();
    private long _lastMessageId;

    AmqpClientReceiver(AmqpClientConnectionImpl client, AmqpSession session, AmqpClientReceiverFactory builder) {
        this._client = client;
        this._address = builder.getAddress();
        this._settleMode = builder.getSettleMode();
        this._decoder = builder.getDecoder();
        this._attachProperties = builder.getAttachProperties() != null ? new HashMap<String, Object>(builder.getAttachProperties()) : null;
        this._sourceProperties = builder.getSourceProperties() != null ? new HashMap<String, Object>(builder.getSourceProperties()) : null;
        this._targetProperties = builder.getTargetProperties() != null ? new HashMap<String, Object>(builder.getTargetProperties()) : null;
        this._prefetch = builder.getPrefetch();
        this._link = new AmqpClientReceiverLink("client-" + this._address, this._address, this);
        DistributionMode distMode = builder.getDistributionMode();
        session.addReceiverLink(this._link, distMode, this._settleMode);
        if (this._prefetch > 0) {
            this._linkCredit = this._prefetch;
            this._link.updatePrefetch(this._prefetch);
        }
    }

    Map<String, Object> getAttachProperties() {
        return this._attachProperties;
    }

    Map<String, Object> getSourceProperties() {
        return this._sourceProperties;
    }

    Map<String, Object> getTargetProperties() {
        return this._targetProperties;
    }

    public int getPrefetchQueueSize() {
        return this._valueQueue.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T pollMicros(long timeoutMicros) {
        ValueNode<T> value = this._valueQueue.poll();
        if (value == null) {
            if (this._linkCredit > 0 || this._prefetch > 0) {
                return null;
            }
            if (this._prefetch == 0) {
                this._link.updatePrefetch(1);
            }
            try {
                value = this._valueQueue.poll(1000L, TimeUnit.MILLISECONDS);
                if (value == null) {
                    T t = null;
                    return t;
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                T t = null;
                return t;
            }
            finally {
                if (this._prefetch == 0) {
                    this._link.updatePrefetch(0);
                }
            }
        }
        this._link.updateTake();
        this._lastMessageId = value.getMessageId();
        return value.getValue();
    }

    @Override
    public long getLastMessageId() {
        return this._lastMessageId;
    }

    @Override
    public void accepted(long mid) {
        this._link.accepted(mid);
    }

    @Override
    public void rejected(long mid, String errorMessage) {
        this._link.rejected(mid, errorMessage);
    }

    @Override
    public void released(long mid) {
        this._link.released(mid);
    }

    @Override
    public void modified(long mid, boolean isFailed, boolean isUndeliverableHere) {
        this._link.modified(mid, isFailed, isUndeliverableHere);
    }

    void receive(long mid, AmqpReader ain) throws IOException {
        Object value = this._decoder.decode(ain, null);
        this._valueQueue.add(new ValueNode<Object>(value, mid));
    }

    public void close() {
        this._link.detach();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._address + "," + this._link + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ValueNode<T> {
        private final T _value;
        private final long _mid;

        ValueNode(T value, long mid) {
            this._value = value;
            this._mid = mid;
        }

        public T getValue() {
            return this._value;
        }

        public long getMessageId() {
            return this._mid;
        }
    }
}

