/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.client;

import com.caucho.amqp.AmqpSender;
import com.caucho.amqp.AmqpSenderFactory;
import com.caucho.amqp.client.AmqpClientConnectionImpl;
import com.caucho.amqp.marshal.AmqpMessageEncoder;
import com.caucho.amqp.marshal.AmqpStringEncoder;
import com.caucho.message.MessageSettleListener;
import com.caucho.message.SettleMode;
import com.caucho.message.common.AbstractMessageSenderFactory;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AmqpClientSenderFactory
extends AbstractMessageSenderFactory
implements AmqpSenderFactory {
    private AmqpClientConnectionImpl _client;
    private AmqpMessageEncoder<?> _encoder = AmqpStringEncoder.ENCODER;
    private HashMap<String, Object> _attachProperties;
    private HashMap<String, Object> _sourceProperties;
    private HashMap<String, Object> _targetProperties;

    AmqpClientSenderFactory(AmqpClientConnectionImpl client) {
        this._client = client;
    }

    @Override
    public AmqpClientSenderFactory setAddress(String address) {
        super.setAddress(address);
        return this;
    }

    @Override
    public AmqpClientSenderFactory setSettleMode(SettleMode settleMode) {
        super.setSettleMode(settleMode);
        return this;
    }

    @Override
    public AmqpClientSenderFactory setSettleListener(MessageSettleListener listener) {
        super.setSettleListener(listener);
        return this;
    }

    @Override
    public AmqpClientSenderFactory setEncoder(AmqpMessageEncoder<?> encoder) {
        if (encoder == null) {
            throw new NullPointerException();
        }
        this._encoder = encoder;
        return this;
    }

    @Override
    public AmqpMessageEncoder<?> getEncoder() {
        return this._encoder;
    }

    @Override
    public AmqpSenderFactory setAttachProperty(String key, Object value) {
        if (this._attachProperties == null) {
            this._attachProperties = new HashMap();
        }
        this._attachProperties.put(key, value);
        return this;
    }

    Map<String, Object> getAttachProperties() {
        return this._attachProperties;
    }

    @Override
    public AmqpSenderFactory setSourceProperty(String key, Object value) {
        if (this._sourceProperties == null) {
            this._sourceProperties = new HashMap();
        }
        this._sourceProperties.put(key, value);
        return this;
    }

    Map<String, Object> getSourceProperties() {
        return this._sourceProperties;
    }

    @Override
    public AmqpSenderFactory setTargetProperty(String key, Object value) {
        if (this._targetProperties == null) {
            this._targetProperties = new HashMap();
        }
        this._targetProperties.put(key, value);
        return this;
    }

    Map<String, Object> getTargetProperties() {
        return this._targetProperties;
    }

    @Override
    public AmqpSender<?> build() {
        return this._client.buildSender(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._client + "]";
    }
}

