/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameTransfer;
import java.io.IOException;

public abstract class AmqpReceiverLink
extends AmqpLink {
    private int _prefetch;
    private long _transferCount;
    private long _transferCountSnapshot;
    private long _takeCount;
    private long _peerDeliveryCount;
    private long _deliveryLimit;

    protected AmqpReceiverLink(String name, String address) {
        super(name, address);
    }

    public final FrameAttach.Role getRole() {
        return FrameAttach.Role.RECEIVER;
    }

    public void afterAttach() {
        this.sendPrefetch(this._prefetch);
    }

    protected int getPrefetchAvailable() {
        return this._prefetch;
    }

    protected void onTransfer(FrameTransfer transfer, AmqpReader ain) throws IOException {
        this.updateTransfer();
    }

    protected final void updateTransfer() {
        ++this._transferCount;
    }

    public void accepted(long mid) {
        this.getSession().accepted(mid);
    }

    public void rejected(long mid, String message) {
        this.getSession().rejected(mid, message);
    }

    public void released(long mid) {
        this.getSession().released(mid);
    }

    public void modified(long mid, boolean isFailure, boolean isUndeliverableHere) {
        this.getSession().modified(mid, isFailure, isUndeliverableHere);
    }

    public void updateTake() {
        long takeCount = ++this._takeCount;
        int prefetch = this._prefetch;
        long limit = this._deliveryLimit;
        long available = limit - this._transferCount;
        if ((takeCount & 0x3FL) == 0L || 2L * available < (long)prefetch || prefetch < 8) {
            this.sendPrefetch(this._prefetch);
        }
    }

    public void setPeerDeliveryCount(long deliveryCount) {
        this._peerDeliveryCount = deliveryCount;
        this._transferCountSnapshot = this._transferCount;
    }

    public final void setPrefetch(int prefetch) {
        this._prefetch = prefetch;
    }

    public void updatePrefetch(int prefetch) {
        this.setPrefetch(prefetch);
        this.sendPrefetch(prefetch);
    }

    private void sendPrefetch(int prefetch) {
        long receiveCount = this._transferCount;
        long receiveCountSnapshot = this._transferCountSnapshot;
        int localQueueSize = (int)(receiveCount - this._takeCount);
        long receiveDelta = receiveCount - receiveCountSnapshot;
        long peerDeliveryCount = this._peerDeliveryCount + receiveDelta;
        this._deliveryLimit = receiveCount + (long)prefetch;
        this.getSession().flow(this, peerDeliveryCount, prefetch - localQueueSize);
    }
}

