/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractFrame;
import com.caucho.amqp.io.AmqpFrameHandler;
import com.caucho.amqp.io.AmqpFrameReader;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.FrameOpen;
import com.caucho.vfs.ReadStream;
import java.io.IOException;

public class AmqpConnectionReader {
    private final AmqpFrameHandler _handler;
    private ReadStream _is;
    private AmqpFrameReader _fin;
    private AmqpReader _ain;

    public AmqpConnectionReader(ReadStream is, AmqpFrameHandler handler) {
        this._is = is;
        this._handler = handler;
        this._fin = new AmqpFrameReader();
        this._fin.init(is);
        this._ain = new AmqpReader();
        this._ain.init(this._fin);
    }

    public boolean readVersion() throws IOException {
        ReadStream is = this._is;
        int ch = is.read();
        if (ch != 65 || is.read() != 77 || is.read() != 81 || is.read() != 80) {
            System.out.println("ILLEGAL_HEADER: " + (char)ch);
            throw new IOException();
        }
        int code = is.read();
        boolean isSasl = false;
        switch (code) {
            case 0: {
                isSasl = false;
                break;
            }
            case 3: {
                isSasl = true;
                break;
            }
            default: {
                System.out.println("BAD_CODE: " + code);
                throw new IOException("Unknown code");
            }
        }
        int major = is.read() & 0xFF;
        int minor = is.read() & 0xFF;
        int version = is.read() & 0xFF;
        if (major != 1 || minor != 0 || version != 0) {
            System.out.println("UNKNOWN_VERSION");
            throw new IOException();
        }
        return true;
    }

    public boolean readFrame() throws IOException {
        if (!this._fin.startFrame()) {
            return false;
        }
        AmqpAbstractFrame frame = this._ain.readObject(AmqpAbstractFrame.class);
        frame.invoke(this._ain, this._handler);
        this._fin.finishFrame();
        return true;
    }

    public boolean readOpen() throws IOException {
        if (!this._fin.startFrame()) {
            return false;
        }
        FrameOpen open = this._ain.readObject(FrameOpen.class);
        this._fin.finishFrame();
        return true;
    }
}

