/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.server;

import com.caucho.amqp.server.AmqpServerConnection;
import com.caucho.amqp.server.AmqpServerReceiverLink;
import com.caucho.amqp.server.AmqpServerSenderLink;
import com.caucho.message.DistributionMode;
import com.caucho.message.SettleMode;
import com.caucho.message.broker.BrokerReceiver;
import com.caucho.message.broker.BrokerSender;
import com.caucho.message.broker.EnvironmentMessageBroker;
import com.caucho.network.listen.Protocol;
import com.caucho.network.listen.ProtocolConnection;
import com.caucho.network.listen.SocketLink;
import java.util.Map;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmqpProtocol
implements Protocol {
    private EnvironmentMessageBroker _broker;

    @PostConstruct
    public void init() {
        this._broker = EnvironmentMessageBroker.create();
        if (this._broker == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public ProtocolConnection createConnection(SocketLink link) {
        return new AmqpServerConnection(this, link);
    }

    AmqpServerReceiverLink createReceiverLink(String name, String address, Map<String, Object> nodeProperties) {
        BrokerSender sender = this._broker.createSender(address, nodeProperties);
        if (sender != null) {
            return new AmqpServerReceiverLink(name, address, sender);
        }
        return null;
    }

    AmqpServerSenderLink createSenderLink(String name, String address, DistributionMode distMode, SettleMode settleMode, Map<String, Object> nodeProperties) {
        AmqpServerSenderLink link = new AmqpServerSenderLink(name, address, settleMode);
        BrokerReceiver receiver = this._broker.createReceiver(address, distMode, nodeProperties, link.getBrokerHandler());
        if (receiver != null) {
            link.setReceiver(receiver);
            return link;
        }
        return null;
    }

    @Override
    public String getProtocolName() {
        return "amqp";
    }
}

