/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.actor;

import com.caucho.bam.BamError;
import com.caucho.bam.actor.Actor;
import com.caucho.bam.actor.BamSkeleton;
import com.caucho.bam.broker.Broker;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkeletonActorFilter<T>
implements Actor {
    private final BamSkeleton<T> _skeleton;
    private final T _actor;
    private final Actor _next;

    public SkeletonActorFilter(Actor next, T actor) {
        if (next == null) {
            throw new IllegalStateException("next is a required argument");
        }
        if (actor == null) {
            throw new IllegalStateException("actor is a required argument");
        }
        this._next = next;
        this._actor = actor;
        this._skeleton = this.createSkeleton(actor);
    }

    protected BamSkeleton<T> createSkeleton(T actor) {
        return BamSkeleton.getSkeleton(actor.getClass());
    }

    @Override
    public String getAddress() {
        return this._next.getAddress();
    }

    @Override
    public boolean isClosed() {
        return this._next.isClosed();
    }

    @Override
    public Broker getBroker() {
        return this._next.getBroker();
    }

    @Override
    public void message(String to, String from, Serializable payload) {
        this._skeleton.message(this._actor, this._next, to, from, payload);
    }

    @Override
    public void messageError(String to, String from, Serializable payload, BamError error) {
        this._skeleton.messageError(this._actor, this._next, to, from, payload, error);
    }

    @Override
    public void query(long id, String to, String from, Serializable payload) {
        this._skeleton.query(this._actor, this._next, this.getBroker(), id, to, from, payload);
    }

    @Override
    public void queryResult(long id, String to, String from, Serializable payload) {
        this._skeleton.queryResult(this._actor, this._next, id, to, from, payload);
    }

    @Override
    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        this._skeleton.queryError(this._actor, this._next, id, to, from, payload, error);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAddress() + "," + this._actor.getClass().getName() + "]";
    }
}

