/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.broker;

import com.caucho.bam.broker.AbstractManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import java.util.concurrent.ConcurrentHashMap;

public class HashMapBroker
extends AbstractManagedBroker {
    private final String _address;
    private final ConcurrentHashMap<String, Mailbox> _mailboxMap = new ConcurrentHashMap();

    public HashMapBroker(String address) {
        this._address = address;
    }

    public String getAddress() {
        return this._address;
    }

    public Mailbox getMailbox(String address) {
        if (address == null) {
            return null;
        }
        return this._mailboxMap.get(address);
    }

    public void addMailbox(String address, Mailbox mailbox) {
        if (address == null) {
            throw new NullPointerException(String.valueOf(mailbox) + " has a null address");
        }
        this._mailboxMap.put(address, mailbox);
    }

    public void removeMailbox(MessageStream actor) {
        String address = actor.getAddress();
        this._mailboxMap.remove(address);
    }
}

