/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.mailbox;

import com.caucho.bam.BamError;
import com.caucho.bam.BamLargePayload;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;

public class DualSizeMailbox
implements Mailbox {
    private final String _address;
    private final Broker _broker;
    private final Mailbox _largeMailbox;
    private final Mailbox _smallMailbox;

    public DualSizeMailbox(String address, Broker broker, Mailbox smallMailbox, Mailbox largeMailbox) {
        this._address = address;
        if (broker == null) {
            throw new NullPointerException();
        }
        this._broker = broker;
        if (largeMailbox == null) {
            throw new NullPointerException();
        }
        this._largeMailbox = largeMailbox;
        if (smallMailbox == null) {
            throw new NullPointerException();
        }
        this._smallMailbox = smallMailbox;
    }

    public int getSize() {
        return this.getSmallQueueSize() + this.getLargeQueueSize();
    }

    public int getSmallQueueSize() {
        return this._smallMailbox.getSize();
    }

    public int getLargeQueueSize() {
        return this._largeMailbox.getSize();
    }

    public String getAddress() {
        return this._address;
    }

    public Broker getBroker() {
        return this._broker;
    }

    public boolean isClosed() {
        return this._smallMailbox.isClosed();
    }

    public MessageStream getActorStream() {
        return this._smallMailbox.getActorStream();
    }

    public void message(String to, String from, Serializable payload) {
        if (payload instanceof BamLargePayload) {
            this._largeMailbox.message(to, from, payload);
        } else {
            this._smallMailbox.message(to, from, payload);
        }
    }

    public void messageError(String to, String from, Serializable payload, BamError error) {
        if (payload instanceof BamLargePayload) {
            this._largeMailbox.messageError(to, from, payload, error);
        } else {
            this._smallMailbox.messageError(to, from, payload, error);
        }
    }

    public void query(long id, String to, String from, Serializable payload) {
        if (payload instanceof BamLargePayload) {
            this._largeMailbox.query(id, to, from, payload);
        } else {
            this._smallMailbox.query(id, to, from, payload);
        }
    }

    public void queryResult(long id, String to, String from, Serializable payload) {
        if (payload instanceof BamLargePayload) {
            this._largeMailbox.queryResult(id, to, from, payload);
        } else {
            this._smallMailbox.queryResult(id, to, from, payload);
        }
    }

    public void queryError(long id, String to, String from, Serializable payload, BamError error) {
        if (payload instanceof BamLargePayload) {
            this._largeMailbox.queryError(id, to, from, payload, error);
        } else {
            this._smallMailbox.queryError(id, to, from, payload, error);
        }
    }

    public void close() {
        this._smallMailbox.close();
        this._largeMailbox.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._smallMailbox + "," + this._largeMailbox + "]";
    }
}

