/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.manager;

import com.caucho.bam.actor.AbstractAgent;
import com.caucho.bam.actor.ActorSender;
import com.caucho.bam.actor.Agent;
import com.caucho.bam.actor.BamActorRef;
import com.caucho.bam.actor.ManagedActor;
import com.caucho.bam.actor.SimpleActor;
import com.caucho.bam.actor.SimpleActorRef;
import com.caucho.bam.broker.Broker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.broker.ManagedBrokerAdapter;
import com.caucho.bam.mailbox.ActorMailbox;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MailboxType;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.mailbox.PassthroughMailbox;
import com.caucho.bam.manager.BamManager;
import com.caucho.bam.proxy.BamProxyFactory;
import com.caucho.bam.proxy.ProxyActor;
import com.caucho.bam.stream.MessageStream;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleBamManager
implements BamManager {
    private final AtomicLong _sequence = new AtomicLong(CurrentTime.getCurrentTime());
    private ManagedBroker _broker;
    private long _timeout = 600000L;

    public SimpleBamManager(Broker broker) {
        this(ManagedBrokerAdapter.create(broker));
    }

    public SimpleBamManager(ManagedBroker broker) {
        this._broker = broker;
        if (broker == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public ManagedBroker getBroker() {
        return this._broker;
    }

    public long getTimeout() {
        return this._timeout;
    }

    @Override
    public void addMailbox(String address, Mailbox mailbox) {
        this.getBroker().addMailbox(address, mailbox);
    }

    @Override
    public void removeMailbox(Mailbox mailbox) {
        this.getBroker().removeMailbox(mailbox);
    }

    @Override
    public void addActor(String address, ManagedActor actor) {
        actor.setAddress(address);
        actor.setBroker(this.getBroker());
        Mailbox mailbox = this.createMailbox(address, actor.getActor(), MailboxType.DEFAULT);
        actor.setMailbox(mailbox);
        this.addMailbox(address, mailbox);
    }

    public void addActorBean(String address, Object bean) {
        ProxyActor<Object> actor = new ProxyActor<Object>(bean, address, this.getBroker());
        Mailbox mailbox = this.createMailbox(address, actor, MailboxType.DEFAULT);
        this.addMailbox(address, mailbox);
    }

    @Override
    public Mailbox createService(String address, Object bean) {
        ProxyActor<Object> actor = new ProxyActor<Object>(bean, address, this.getBroker());
        Mailbox mailbox = this.createMailbox(address, actor, MailboxType.MULTI_WORKER);
        this.addMailbox(address, mailbox);
        return mailbox;
    }

    @Override
    public Agent createAgent(MessageStream actorStream) {
        return this.createAgent(actorStream, MailboxType.DEFAULT);
    }

    @Override
    public Agent createAgent(MessageStream actorStream, MailboxType mailboxType) {
        String address = actorStream.getAddress();
        Mailbox mailbox = this.createMailbox(address, actorStream, mailboxType);
        AbstractAgent agent = new AbstractAgent(address, mailbox, this.getBroker());
        this.addMailbox(address, mailbox);
        return agent;
    }

    protected Mailbox createMailbox(MessageStream actorStream, MailboxType mailboxType) {
        return this.createMailbox(actorStream.getAddress(), actorStream, mailboxType);
    }

    protected Mailbox createMailbox(String address, MessageStream actorStream, MailboxType mailboxType) {
        switch (mailboxType) {
            case NON_QUEUED: {
                return new PassthroughMailbox(address, actorStream, this.getBroker());
            }
            case ACTOR: {
                return new ActorMailbox(address, actorStream, this.getBroker());
            }
            case MULTI_WORKER: {
                return new MultiworkerMailbox(address, actorStream, this.getBroker(), 5);
            }
        }
        return new MultiworkerMailbox(address, actorStream, this.getBroker(), 5);
    }

    @Override
    public Mailbox createClient(Mailbox next, String uid, String resource) {
        Mailbox mailbox;
        String address = null;
        if (uid == null) {
            uid = Long.toHexString(this._sequence.incrementAndGet());
        }
        if (uid.indexOf(64) < 0) {
            uid = uid + '@' + this.getBroker().getAddress();
        }
        if (resource != null) {
            address = uid + "/" + resource;
            mailbox = this.getBroker().getMailbox(address);
            if (mailbox != null) {
                address = uid + "/" + resource + "-" + Long.toHexString(this._sequence.incrementAndGet());
            }
        } else {
            address = uid + "/" + Long.toHexString(this._sequence.incrementAndGet());
        }
        mailbox = new PassthroughMailbox(address, next, this.getBroker());
        this.addMailbox(address, mailbox);
        return mailbox;
    }

    @Override
    public ActorSender createClient(String uid, String resource) {
        String address = null;
        if (uid == null) {
            uid = Long.toHexString(this._sequence.incrementAndGet());
        }
        if (uid.indexOf(64) < 0) {
            uid = uid + '@' + this.getBroker().getAddress();
        }
        if (resource != null) {
            address = uid + "/" + resource;
            Mailbox mailbox = this.getBroker().getMailbox(address);
            if (mailbox != null) {
                address = uid + "/" + resource + "-" + Long.toHexString(this._sequence.incrementAndGet());
            }
        } else {
            address = uid + "/" + Long.toHexString(this._sequence.incrementAndGet());
        }
        SimpleActor actor = new SimpleActor(address, this.getBroker());
        this.addActor(address, actor);
        return actor.getSender();
    }

    @Override
    public BamActorRef createActorRef(String to) {
        return new SimpleActorRef(to, this.getBroker());
    }

    @Override
    public <T> T createProxy(Class<T> api, String to) {
        ActorSender sender = this.createClient(api.getSimpleName(), null);
        return this.createProxy(api, this.createActorRef(to), sender);
    }

    @Override
    public <T> T createProxy(Class<T> api, BamActorRef to, ActorSender sender) {
        return BamProxyFactory.createProxy(api, to, sender, this.getTimeout());
    }

    @Override
    public <T> T createProxy(Class<T> api, String to, ActorSender sender) {
        return BamProxyFactory.createProxy(api, this.createActorRef(to), sender, this.getTimeout());
    }

    public ActorSender createClient(String address) {
        SimpleActor actor = new SimpleActor(address, this.getBroker());
        this.addActor(address, actor);
        return actor.getSender();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBroker().getAddress() + "]";
    }
}

