/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;

public abstract class AbstractDeployCatCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(AbstractDeployCatCommand.class);

    protected void initBootOptions() {
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        super.initBootOptions();
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public String getDescription() {
        return "prints a deployed file";
    }

    public String getUsageArgs() {
        return " <filename>";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String fileName = args.getDefaultArg();
        if (fileName == null) {
            throw new ConfigException(L.l("Cannot find a filename in command line"));
        }
        CommitBuilder commit = this.createCommitBuilder(args);
        try {
            WriteStream out = Vfs.openWrite(System.out);
            deployClient.getFile(commit.getId(), fileName, out);
            out.flush();
        }
        catch (IOException e) {
            throw ConfigException.create(e);
        }
        return 0;
    }

    protected abstract CommitBuilder createCommitBuilder(WatchdogArgs var1);
}

