/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.bam.RemoteConnectionFailedException;
import com.caucho.bam.RemoteListenerUnavailableException;
import com.caucho.bam.actor.RemoteActorSender;
import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.OpenPort;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.hmtp.HmtpClient;
import com.caucho.server.admin.HmuxClientFactory;
import com.caucho.util.L10N;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractRemoteCommand
extends AbstractBootCommand {
    private static final L10N L = new L10N(AbstractRemoteCommand.class);
    private static final Logger log = Logger.getLogger(AbstractRemoteCommand.class.getName());

    protected void initBootOptions() {
        this.addSubsectionHeaderOption("remote connection options:");
        this.addValueOption("server", "id", "id of a server in the config file");
        this.addValueOption("address", "ip", "IP address or host name of (triad) server");
        this.addIntValueOption("port", "port", "IP port of (triad) server");
        this.addSpacerOption();
        this.addValueOption("user", "user", "admin user name for authentication");
        this.addValueOption("password", "password", "admin password for authentication");
        super.initBootOptions();
    }

    protected RemoteActorSender createBamClient(WatchdogArgs args, WatchdogClient client) {
        int p;
        String address = args.getArg("-address");
        int port = -1;
        if (address != null && (p = address.lastIndexOf(58)) >= 0) {
            port = Integer.parseInt(address.substring(p + 1));
            address = address.substring(0, p);
        }
        port = args.getArgInt("-port", port);
        String user = args.getArg("-user");
        String password = args.getArg("-password");
        if (user == null || "".equals(user)) {
            user = "";
            password = client.getClusterSystemKey();
        }
        return this.createBamClient(client, address, port, user, password);
    }

    private RemoteActorSender createBamClient(WatchdogClient client, String address, int port, String userName, String password) {
        WatchdogClient liveClient = client;
        RemoteActorSender hmuxClient = this.createHmuxClient(client, address, port, userName, password);
        if (hmuxClient != null) {
            return hmuxClient;
        }
        if (address == null || address.isEmpty()) {
            liveClient = this.findLiveClient(client, port);
            address = liveClient.getConfig().getAddress();
        }
        if (port <= 0) {
            port = this.findPort(liveClient);
        }
        if (port <= 0) {
            throw new ConfigException(L.l("Cannot find live Resin server for deployment at {0}:{1} was not found", (Object)address, port));
        }
        return this.createHmtpClient(address, port, userName, password);
    }

    private RemoteActorSender createHmtpClient(String address, int port, String userName, String password) {
        String url = "http://" + address + ":" + port + "/hmtp";
        HmtpClient client = new HmtpClient(url);
        try {
            client.setVirtualHost("admin.resin");
            client.connect(userName, password);
            return client;
        }
        catch (RemoteConnectionFailedException e) {
            throw new RemoteConnectionFailedException(L.l("Connection to '{0}' failed for remote administration.\n  Ensure the local server has started, or include --server and --port parameters to connect to a remote server.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
        catch (RemoteListenerUnavailableException e) {
            throw new RemoteListenerUnavailableException(L.l("Connection to '{0}' failed for remote administration because RemoteAdminService (HMTP) is not enabled.\n  Ensure 'remote_admin_enable' is set true in resin.properties.\n  {1}", (Object)url, (Object)e.getMessage()), e);
        }
    }

    private RemoteActorSender createHmuxClient(WatchdogClient client, String address, int port, String userName, String password) {
        WatchdogClient server = address != null && !"".equals(address) && port > 0 ? this.findServer(client, address, port) : (this.clientCanConnect(client) ? client : this.findLiveTriad(client));
        if (server == null) {
            return null;
        }
        address = server.getConfig().getAddress();
        port = server.getConfig().getPort();
        HmuxClientFactory hmuxFactory = new HmuxClientFactory(address, port, userName, password);
        try {
            return hmuxFactory.create();
        }
        catch (RemoteConnectionFailedException e) {
            throw new RemoteConnectionFailedException(L.l("Connection to '{0}' failed for remote administration.\n  Ensure the local server has started, or include --server and --port parameters to connect to a remote server.\n  {1}", (Object)server, (Object)e.getMessage()), e);
        }
        catch (RemoteListenerUnavailableException e) {
            throw new RemoteListenerUnavailableException(L.l("Connection to '{0}' failed for remote administration because RemoteAdminService (HMTP) is not enabled.\n  Ensure 'remote_admin_enable' is set true in resin.properties.\n  {1}", (Object)server, (Object)e.getMessage()), e);
        }
    }

    private WatchdogClient findLiveTriad(WatchdogClient client) {
        for (WatchdogClient triad : client.getConfig().getCluster().getClients()) {
            int port;
            if (this.clientCanConnect(triad, port = triad.getConfig().getPort())) {
                return triad;
            }
            if (triad.getIndex() <= 2) continue;
            break;
        }
        return null;
    }

    private WatchdogClient findServer(WatchdogClient client, String address, int port) {
        for (WatchdogClient server : client.getConfig().getCluster().getClients()) {
            if (!this.isEqual(address, server.getConfig().getAddress()) || port != server.getConfig().getPort()) continue;
            return server;
        }
        return null;
    }

    private boolean isEqual(String address1, String address2) {
        if (address1.equals(address2)) {
            return true;
        }
        try {
            InetAddress inetAddress1 = InetAddress.getByName(address1);
            InetAddress inetAddress2 = InetAddress.getByName(address2);
            return inetAddress1.equals(inetAddress2);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    private WatchdogClient findLiveClient(WatchdogClient client, int port) {
        for (WatchdogClient triad : client.getConfig().getCluster().getClients()) {
            int triadPort = port;
            if (triadPort <= 0) {
                triadPort = this.findPort(triad);
            }
            if (this.clientCanConnect(triad, triadPort)) {
                return triad;
            }
            if (triad.getIndex() <= 2) continue;
            break;
        }
        return client;
    }

    private boolean clientCanConnect(WatchdogClient client, int port) {
        return this.clientCanConnect(client);
    }

    private boolean clientCanConnect(WatchdogClient client) {
        String address = client.getConfig().getAddress();
        int clusterPort = client.getConfig().getPort();
        try {
            Socket s = new Socket(address, clusterPort);
            s.close();
            return true;
        }
        catch (IOException e) {
            log.log(Level.FINER, e.toString(), e);
            return false;
        }
    }

    private int findPort(WatchdogClient client) {
        for (OpenPort openPort : client.getConfig().getPorts()) {
            if (!"http".equals(openPort.getProtocolName())) continue;
            return openPort.getPort();
        }
        return 0;
    }
}

