/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.BootManagementConfig;
import com.caucho.boot.BootResinConfig;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogConfig;
import com.caucho.boot.WatchdogConfigHandle;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.env.service.ResinSystem;
import com.caucho.server.resin.BootServerMultiConfig;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BootClusterConfig {
    private static final L10N L = new L10N(BootClusterConfig.class);
    private ResinSystem _system;
    private BootResinConfig _resin;
    private String _id = "";
    private boolean _isDynamicServerEnable;
    private ConfigProgram _stdoutLog;
    private ArrayList<ContainerProgram> _serverDefaultList = new ArrayList();
    private ArrayList<ConfigProgram> _elasticServerDefaultList = new ArrayList();
    private ArrayList<WatchdogClient> _serverList = new ArrayList();

    BootClusterConfig(ResinSystem system, BootResinConfig resin) {
        this._system = system;
        this._resin = resin;
    }

    public BootResinConfig getResin() {
        return this._resin;
    }

    @Configurable
    public void setId(String id) {
        this._id = id;
    }

    public String getId() {
        return this._id;
    }

    public void setDynamicServerEnable(boolean isEnabled) {
        this._isDynamicServerEnable = isEnabled;
    }

    public boolean isClusterServerEnable() {
        return this._isDynamicServerEnable;
    }

    public void addServerDefault(ContainerProgram program) {
        this._serverDefaultList.add(program);
    }

    public void addManagement(BootManagementConfig management) {
        this._resin.setManagement(management);
    }

    public WatchdogConfigHandle createServer() {
        WatchdogConfigHandle config = new WatchdogConfigHandle(this, this._resin.getArgs(), this._resin.getRootDirectory(), this._serverList.size());
        for (int i = 0; i < this._serverDefaultList.size(); ++i) {
            this._serverDefaultList.get(i).configure(config);
        }
        return config;
    }

    public WatchdogConfig addServer(WatchdogConfigHandle configHandle) throws ConfigException {
        WatchdogConfig config = configHandle.configure();
        for (int i = 0; i < this._elasticServerDefaultList.size(); ++i) {
            this._elasticServerDefaultList.get(i).configure(config);
        }
        this.addServerImpl(config);
        return config;
    }

    public void addServerImpl(WatchdogConfig config) {
        if (this._resin.findClient(config.getId()) != null) {
            throw new ConfigException(L.l("<server id='{0}'> is a duplicate server.  servers must have unique ids.", (Object)config.getId()));
        }
        WatchdogClient client = this._resin.findClientByAddress(config.getAddress(), config.getPort());
        if (client != null) {
            throw new ConfigException(L.l("<server id='{0}'> has a duplicate address {1}:{2} to server '{3}'.\nServers must have unique addresses.", (Object)config.getId(), (Object)config.getAddress(), (Object)config.getPort(), (Object)client.getId()));
        }
        this._resin.addServer(config);
        client = new WatchdogClient(this._system, this._resin, config);
        this._resin.addClient(client);
        this._serverList.add(client);
    }

    public ArrayList<WatchdogClient> getServerList() {
        return this._serverList;
    }

    public void addServerMulti(BootServerMultiConfig multiServer) {
        int index = 0;
        this._elasticServerDefaultList.add(multiServer.getServerProgram());
        for (String address : multiServer.getAddressList()) {
            WatchdogConfigHandle serverHandle = this.createServer();
            serverHandle.setId(multiServer.getIdPrefix() + index++);
            boolean isExternal = false;
            if (address.startsWith("ext:")) {
                isExternal = true;
                address = address.substring("ext:".length());
            }
            int p = address.lastIndexOf(58);
            int port = multiServer.getPort();
            if (p > 0) {
                port = Integer.parseInt(address.substring(p + 1));
                address = address.substring(0, p);
            }
            boolean isAllowNonReservedIp = multiServer.isAllowNonReservedIp();
            serverHandle.setAddress(address);
            serverHandle.setPort(port);
            WatchdogConfig server = this.addServer(serverHandle);
            multiServer.getServerProgram().configure(server);
        }
    }

    public ArrayList<WatchdogClient> getClients() {
        return this._serverList;
    }

    public void addStdoutLog(ContainerProgram config) {
        this._stdoutLog = config;
    }

    public ConfigProgram getStdoutLog() {
        return this._stdoutLog;
    }

    public void addContentProgram(ConfigProgram program) {
        QName qName = program.getQName();
        if (qName != null && qName.getLocalName().equals("ElasticCloudService")) {
            this._isDynamicServerEnable = true;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._id + "]";
    }
}

