/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.L10N;

public class DisableCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(DisableCommand.class);

    public String getDescription() {
        return "disables a server for http/load-balancing";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient manager) throws BootArgumentException {
        String serverId = args.getDefaultArg();
        if (serverId == null) {
            serverId = args.getServerId();
        }
        if (serverId == null) {
            throw new ConfigException(L.l("{0}: -server is not specified", (Object)this.getName()));
        }
        String result = manager.disable(serverId);
        System.out.println(result);
        return 0;
    }

    public String getUsageArgs() {
        return " [<server>]";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

