/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStopCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.util.L10N;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KillCommand
extends AbstractStopCommand {
    private static Logger _log;
    private static L10N _L;

    public String getDescription() {
        return "forces a kill of a Resin server";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.killWatchdog(args.getServerId());
            System.out.println(KillCommand.L().l("Resin/{0} killed{1} for watchdog at {2}:{3}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args.getServerId(), client.getId()), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            System.out.println(KillCommand.L().l("Resin/{0} can't kill -server '{1}' (client {2}) for watchdog at {3}:{4}.\n{5}", (Object)VersionFactory.getVersion(), (Object)args.getServerId(), (Object)client, (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)e.toString()));
            KillCommand.log().log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    public boolean isRetry() {
        return true;
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(KillCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(KillCommand.class);
        }
        return _L;
    }
}

