/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.types.Period;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.L10N;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

public class LogLevelCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(LogLevelCommand.class);
    private static final Map<String, Level> _options = new LinkedHashMap<String, Level>();

    protected void initBootOptions() {
        this.addFlagOption("all", "all logs (rare to use)");
        this.addFlagOption("finest", "finest debugging log");
        this.addFlagOption("finer", "finer debugging logs (developer-level)");
        this.addFlagOption("fine", "finer debugging logs (admin/user-level)");
        this.addFlagOption("config", "configuration debugging logs");
        this.addFlagOption("info", "default logging level");
        this.addFlagOption("warning", "non-fatal warnings");
        this.addFlagOption("severe", "severe, typically fatal warnings");
        this.addFlagOption("off", "disable logging");
        this.addSpacerOption();
        this.addValueOption("active-time", "time", "specifies temporary level active time (default permanent). e.g. 5s");
        super.initBootOptions();
    }

    public String getUsageArgs() {
        return " <logger> <logger> ...";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }

    public String getDescription() {
        return "sets the java.util.logging level for debugging";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        String[] loggers;
        Level logLevel = null;
        for (Map.Entry<String, Level> entry : _options.entrySet()) {
            if (!args.hasOption(entry.getKey())) continue;
            logLevel = entry.getValue();
            break;
        }
        if (logLevel == null) {
            this.usage(false);
            return 3;
        }
        long period = 0L;
        String time = args.getArg("-active-time");
        if (time != null) {
            period = Period.toPeriod(time);
        }
        if ((loggers = args.getDefaultArgs()) == null || loggers.length == 0) {
            loggers = new String[]{"", "com.caucho"};
        }
        StringQueryReply result = managerClient.setLogLevel(loggers, logLevel, period);
        System.out.println(result.getValue());
        return 0;
    }

    public static Level getLevel(String level) {
        return _options.get(level);
    }

    static {
        _options.put("-all", Level.ALL);
        _options.put("-finest", Level.FINEST);
        _options.put("-finer", Level.FINER);
        _options.put("-fine", Level.FINE);
        _options.put("-config", Level.CONFIG);
        _options.put("-info", Level.INFO);
        _options.put("-warning", Level.WARNING);
        _options.put("-severe", Level.SEVERE);
        _options.put("-off", Level.OFF);
    }
}

