/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractBootCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.io.Console;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.logging.Logger;

public class PasswordGenerateCommand
extends AbstractBootCommand {
    private static Logger _log;
    private static L10N _L;

    protected void initBootOptions() {
        this.addValueOption("user", "user", "the user name to generate a password hash");
        this.addValueOption("password", "password", "the password for the password hash (leave empty for prompt)");
        super.initBootOptions();
    }

    public String getDescription() {
        return "generates an administrator user and password";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        String user = args.getArg("-user");
        String password = args.getArg("-password");
        ArrayList<String> tailArgs = args.getTailArgs();
        if (tailArgs.size() == 2 && !((String)tailArgs.get(0)).startsWith("-") && !((String)tailArgs.get(1)).startsWith("-")) {
            user = (String)tailArgs.get(0);
            password = (String)tailArgs.get(1);
        }
        if (user == null) {
            throw new ConfigException(PasswordGenerateCommand.L().l("generate-password requires a --user argument"));
        }
        if (password == null) {
            password = PasswordGenerateCommand.readPasswordFromConsole("Enter");
            String password2 = PasswordGenerateCommand.readPasswordFromConsole("Verify");
            if (password == null || !password.equals(password2)) {
                throw new ConfigException(PasswordGenerateCommand.L().l("password must match"));
            }
        }
        if (password == null) {
            throw new ConfigException(PasswordGenerateCommand.L().l("generate-password requires a -password argument"));
        }
        byte[] salt = new byte[]{(byte)RandomUtil.getRandomLong(), (byte)RandomUtil.getRandomLong(), (byte)RandomUtil.getRandomLong(), (byte)RandomUtil.getRandomLong()};
        CharBuffer cb = new CharBuffer();
        byte[] digest = this.sha1(password, salt);
        byte[] hash = new byte[salt.length + digest.length];
        System.arraycopy(digest, 0, hash, 0, digest.length);
        System.arraycopy(salt, 0, hash, digest.length, salt.length);
        Base64.encode(cb, hash);
        String sshaPassword = "{SSHA}" + cb;
        System.out.println("admin_user : " + user);
        System.out.println("admin_password : " + sshaPassword);
        return 0;
    }

    private static String readPasswordFromConsole(String msg) {
        try {
            Console console = System.console();
            if (console == null) {
                System.out.println(PasswordGenerateCommand.L().l("Warning: interactive console is not available"));
                return null;
            }
            char[] passwordChars = console.readPassword(msg + " password: ", new Object[0]);
            if (passwordChars == null || passwordChars.length == 0) {
                return null;
            }
            return new String(passwordChars);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private byte[] sha1(String password, byte[] salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA1");
            for (int i = 0; i < password.length(); ++i) {
                digest.update((byte)password.charAt(i));
            }
            digest.update(salt);
            return digest.digest();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    private static Logger log() {
        if (_log == null) {
            _log = Logger.getLogger(PasswordGenerateCommand.class.getName());
        }
        return _log;
    }

    private static L10N L() {
        if (_L == null) {
            _L = new L10N(PasswordGenerateCommand.class);
        }
        return _L;
    }

    public String getUsageArgs() {
        return " [<user>] [<password>]";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

