/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.VersionFactory;
import com.caucho.boot.AbstractStartCommand;
import com.caucho.boot.BootArgumentException;
import com.caucho.boot.ResinBoot;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.boot.WatchdogManager;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartCloudCommand
extends AbstractStartCommand {
    private static final L10N L = new L10N(StartCloudCommand.class);
    private static final Logger log = Logger.getLogger(StartCloudCommand.class.getName());

    public String getDescription() {
        return "starts all servers listening to the machine's IP interfaces";
    }

    protected WatchdogClient findLocalClient(ResinBoot boot, WatchdogArgs args) {
        return this.findLocalClientImpl(boot, args);
    }

    protected WatchdogClient findWatchdogClient(ResinBoot boot, WatchdogArgs args) {
        return this.findWatchdogClientImpl(boot, args);
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client) throws BootArgumentException {
        try {
            client.startAllWatchdog(args.getArgv(), true);
            System.out.println(L.l("Resin/{0} started{1} with watchdog at {2}:{3}", (Object)VersionFactory.getVersion(), (Object)this.getServerUsageArg(args, client.getId()), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort()));
        }
        catch (Exception e) {
            String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
            System.out.println(L.l("Resin/{0} can't start-cloud for watchdog at {1}:{2}.\n  {3}", (Object)VersionFactory.getVersion(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
            log.log(Level.FINE, e.toString(), e);
            System.exit(1);
        }
        return 0;
    }

    public void doWatchdogStart(WatchdogManager manager) {
        ArrayList<WatchdogClient> clientList;
        WatchdogArgs args = manager.getArgs();
        String serverId = args.getClientServerId();
        if (serverId != null && args.isElasticServer()) {
            manager.startServer(serverId, args.getArgv());
            return;
        }
        do {
            if ((clientList = manager.getManagerConfig().findLocalClients(null)).size() != 0) continue;
            try {
                log.info("No local IP address found, waiting...");
                Thread.sleep(10000L);
            }
            catch (Exception e) {
                // empty catch block
            }
        } while (clientList.size() == 0);
        for (WatchdogClient client : clientList) {
            try {
                manager.startServer(client.getId(), args.getArgv());
            }
            catch (Exception e) {
                String eMsg = e instanceof ConfigException ? e.getMessage() : e.toString();
                System.out.println(L.l("Resin/{0} can't start -server '{1}' for watchdog at {2}:{3}.\n  {4}", (Object)VersionFactory.getVersion(), (Object)client.getId(), (Object)client.getWatchdogAddress(), (Object)client.getWatchdogPort(), (Object)eMsg));
                log.log(Level.FINE, e.toString(), e);
            }
        }
    }
}

