/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.server.deploy.DeployClient;
import com.caucho.util.L10N;

public class WebAppUndeployCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(WebAppUndeployCommand.class);

    protected void initBootOptions() {
        this.addValueOption("host", "host", "virtual host to make application available on");
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        this.addSpacerOption();
        this.addValueOption("m", "message", "commit message");
        super.initBootOptions();
    }

    public String getDescription() {
        return "undeploys an application";
    }

    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String name = args.getDefaultArg();
        if (name == null) {
            name = args.getArg("-name");
        }
        if (name == null) {
            throw new ConfigException(L.l("Cannot find context argument in command line"));
        }
        String host = args.getArg("-host");
        if (host == null) {
            host = "default";
        }
        CommitBuilder commit = new CommitBuilder();
        commit.type("webapp");
        String stage = args.getArg("-stage");
        if (stage != null) {
            commit.stage(stage);
        }
        commit.tagKey(host + "/" + name);
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = "undeploy " + name + " from command line";
        }
        commit.message(message);
        commit.attribute("user", System.getProperty("user.name"));
        String version = args.getArg("-version");
        if (version != null) {
            DeployClient.fillInVersion(commit, version);
        }
        deployClient.removeTag(commit);
        System.out.println("Undeployed " + name + " from " + deployClient.getUrl());
        return 0;
    }

    public String getUsageArgs() {
        return " <name>";
    }

    public boolean isDefaultArgsAccepted() {
        return true;
    }
}

