/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bytecode;

import com.caucho.bytecode.JClass;
import com.caucho.bytecode.JClassLoader;
import com.caucho.bytecode.JField;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JType;
import com.caucho.util.CharBuffer;

public class JavaParameterizedType
implements JType {
    private JClassLoader _loader;
    private JClass _rawClass;
    private JType[] _typeArgs;

    JavaParameterizedType(JClassLoader loader, JClass rawClass, JType[] args) {
        this._loader = loader;
        this._rawClass = rawClass;
        this._typeArgs = args;
    }

    public String getName() {
        return this._rawClass.getName();
    }

    public String getPrintName() {
        if (this._typeArgs.length == 0) {
            return this._rawClass.getPrintName();
        }
        CharBuffer cb = new CharBuffer();
        cb.append(this._rawClass.getPrintName());
        cb.append('<');
        for (int i = 0; i < this._typeArgs.length; ++i) {
            if (i != 0) {
                cb.append(',');
            }
            cb.append(this._typeArgs[i].getPrintName());
        }
        cb.append('>');
        return cb.toString();
    }

    public JType[] getActualTypeArguments() {
        return this._typeArgs;
    }

    public JClass getRawType() {
        return this._rawClass;
    }

    public boolean isPrimitive() {
        return this._rawClass.isPrimitive();
    }

    public boolean isPublic() {
        return this._rawClass.isPublic();
    }

    public boolean isAbstract() {
        return this._rawClass.isAbstract();
    }

    public boolean isFinal() {
        return this._rawClass.isFinal();
    }

    public boolean isInterface() {
        return this._rawClass.isAbstract();
    }

    public JClass getSuperClass() {
        return this._rawClass.getSuperClass();
    }

    public JClass[] getInterfaces() {
        return this._rawClass.getInterfaces();
    }

    public boolean isArray() {
        return this._rawClass.isArray();
    }

    public JClass getComponentType() {
        return null;
    }

    public boolean isAssignableTo(Class cl) {
        return this._rawClass.isAssignableTo(cl);
    }

    public boolean isAssignableFrom(Class cl) {
        return this._rawClass.isAssignableFrom(cl);
    }

    public boolean isAssignableFrom(JClass cl) {
        return this._rawClass.isAssignableFrom(cl);
    }

    public JMethod[] getDeclaredMethods() {
        return this._rawClass.getDeclaredMethods();
    }

    public JMethod[] getMethods() {
        return this._rawClass.getMethods();
    }

    public JMethod getMethod(String name, JClass[] param) {
        return this._rawClass.getMethod(name, param);
    }

    public JField[] getDeclaredFields() {
        return this._rawClass.getDeclaredFields();
    }

    public JField[] getFields() {
        return this._rawClass.getFields();
    }
}

