/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.core;

import com.caucho.config.Config;
import com.caucho.config.ConfigException;
import com.caucho.config.annotation.NoAspect;
import com.caucho.config.core.ResinControl;
import com.caucho.config.type.FlowBean;
import com.caucho.config.types.FileSetType;
import com.caucho.loader.Environment;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

@NoAspect
public class ResinProperties
extends ResinControl
implements FlowBean {
    private static final L10N L = new L10N(ResinProperties.class);
    private static final Logger log = Logger.getLogger(ResinProperties.class.getName());
    private Path _path;
    private FileSetType _fileSet;
    private boolean _isOptional;
    private boolean _isRecover;
    private String _mode = "[default]";

    public void setPath(Path path) {
        if (path == null) {
            throw new NullPointerException(L.l("'path' may not be null for resin:properties"));
        }
        this._path = path;
    }

    public void setFileset(FileSetType fileSet) {
        this._fileSet = fileSet;
    }

    public void setOptional(boolean optional) {
        this._isOptional = optional;
    }

    public void setRecover(boolean isRecover) {
        this._isRecover = isRecover;
    }

    public void setMode(String mode) {
        this._mode = mode == null || "".equals(mode) ? "[default]" : (mode.startsWith("[") ? mode : "[" + mode + "]");
    }

    @PostConstruct
    public void init() throws Exception {
        ArrayList<Path> paths;
        if (this._path == null && this._fileSet == null) {
            throw new ConfigException(L.l("'path' attribute missing from resin:properties."));
        }
        if (this._fileSet != null) {
            paths = this._fileSet.getPaths();
        } else {
            paths = new ArrayList();
            paths.add(this._path);
        }
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.get(i);
            try {
                log.config(L.l("resin:properties '{0}'", (Object)path.getNativePath()));
                Environment.addDependency(new Depend(path));
                this.readProperties(path);
                continue;
            }
            catch (FileNotFoundException e) {
                if (this._isOptional) continue;
                throw new ConfigException(L.l("Required file '{0}' can not be read for resin:import.", (Object)path.getNativePath()));
            }
            catch (IOException e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties(Path path) throws IOException {
        ReadStream is = null;
        String mode = "";
        try {
            String line;
            is = path.openRead();
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            ClassLoader systemLoader = ClassLoader.getSystemClassLoader();
            if (loader.getParent().equals(systemLoader)) {
                loader = systemLoader;
            }
            while ((line = is.readLine()) != null) {
                while (line.endsWith("\\")) {
                    line = line.substring(0, line.length() - 1);
                    String contLine = is.readLine();
                    if (contLine == null) continue;
                    line = line + contLine;
                }
                int p = (line = line.trim()).indexOf(35);
                if (p >= 0) {
                    line = line.substring(0, p);
                }
                if (line.startsWith("#") || line.equals("")) continue;
                if (line.startsWith("[")) {
                    mode = line;
                    continue;
                }
                p = line.indexOf(58);
                int q = line.indexOf(61);
                if (p < 0 || q >= 0 && q < p) {
                    p = q;
                }
                if (p < 0) {
                    throw new ConfigException(L.l("invalid line in {0}\n  {1}", (Object)path, (Object)line));
                }
                if (!"".equals(mode) && !mode.equals(this._mode)) continue;
                String key = line.substring(0, p).trim();
                String value = line.substring(p + 1).trim();
                Config.setProperty(key, value, loader);
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            IoUtil.close(is);
            throw throwable;
        }
        IoUtil.close(is);
    }
}

