/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.reflect.VarType;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AspectGeneratorUtil {
    public static void generateHeader(JavaWriter out, boolean isOverride, String accessModifier, String methodName, AnnotatedMethod<?> method, Set<VarType<?>> typeVariables, Class<?>[] exnList) throws IOException {
        out.println();
        if (isOverride) {
            out.println("@Override");
        }
        if (accessModifier != null) {
            out.print(accessModifier);
            out.print(" ");
        }
        if (typeVariables != null && typeVariables.size() > 0) {
            out.print("<");
            boolean isFirst = true;
            for (VarType<?> var : typeVariables) {
                if (!isFirst) {
                    out.print(",");
                }
                isFirst = false;
                out.printVarType(var);
            }
            out.println(">");
        }
        Type returnType = method.getBaseType();
        out.printType(returnType);
        out.print(" ");
        out.print(methodName);
        out.print("(");
        Method javaMethod = method.getJavaMember();
        List params = method.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            AnnotatedParameter param = params.get(i);
            Type type = param.getBaseType();
            Class cl = null;
            if (type instanceof Class) {
                cl = (Class)type;
            }
            if (i != 0) {
                out.print(", ");
            }
            if (i == params.size() - 1 && cl != null && cl.isArray() && javaMethod.isVarArgs()) {
                out.printClass(cl.getComponentType());
                out.print("...");
            } else {
                out.printType(type);
            }
            out.print(" a" + i);
        }
        out.println(")");
        AspectGeneratorUtil.generateThrows(out, exnList);
    }

    protected static void generateThrows(JavaWriter out, Class<?>[] exnCls) throws IOException {
        if (exnCls.length == 0) {
            return;
        }
        out.print(" throws ");
        for (int i = 0; i < exnCls.length; ++i) {
            if (i != 0) {
                out.print(", ");
            }
            out.printClass(exnCls[i]);
        }
        out.println();
    }
}

