/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.gen;

import com.caucho.config.gen.AbstractAspectGenerator;
import com.caucho.config.gen.AspectGenerator;
import com.caucho.config.gen.SecurityFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.enterprise.inject.spi.AnnotatedMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class SecurityGenerator<X>
extends AbstractAspectGenerator<X> {
    private String[] _roles;
    private String _roleVar;
    private String _runAs;

    public SecurityGenerator(SecurityFactory<X> factory, AnnotatedMethod<? super X> method, AspectGenerator<X> next, String[] roleNames, String runAs) {
        super(factory, method, next);
        this._roles = roleNames;
        this._runAs = runAs;
    }

    @Override
    public void generateMethodPrologue(JavaWriter out, HashMap<String, Object> map) throws IOException {
        if (this._roles != null) {
            this._roleVar = "_role_" + out.generateId();
            out.print("private static String []" + this._roleVar + " = new String[] {");
            for (int i = 0; i < this._roles.length; ++i) {
                if (i != 0) {
                    out.print(", ");
                }
                out.print("\"");
                out.printJavaString(this._roles[i]);
                out.print("\"");
            }
            out.println("};");
        }
        super.generateMethodPrologue(out, map);
    }

    @Override
    public void generatePreTry(JavaWriter out) throws IOException {
        if (this._roleVar != null) {
            out.println("com.caucho.security.SecurityContext.checkUserInRole(" + this._roleVar + ");");
            out.println();
        }
        if (this._runAs != null) {
            out.print("String oldRunAs = com.caucho.security.SecurityContext.runAs(\"");
            out.printJavaString(this._runAs);
            out.println("\");");
        }
        super.generatePreTry(out);
    }

    @Override
    public void generateFinally(JavaWriter out) throws IOException {
        super.generateFinally(out);
        if (this._runAs != null) {
            out.println();
            out.println("com.caucho.security.SecurityContext.runAs(oldRunAs);");
        }
    }
}

