/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.CandiEnhancedBean;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.DecoratorBean;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.Arg;
import com.caucho.config.program.ConfigProgram;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.CreationException;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class CandiProducer<X>
implements InjectionTarget<X> {
    private static final L10N L = new L10N(CandiProducer.class);
    private static final Logger log = Logger.getLogger(CandiProducer.class.getName());
    private static final Object[] NULL_ARGS = new Object[0];
    private InjectManager _injectManager = InjectManager.create();
    private Class<X> _instanceClass;
    private Bean<X> _bean;
    private Constructor<X> _javaCtor;
    private Arg[] _args;
    private ConfigProgram[] _injectProgram;
    private ConfigProgram[] _initProgram;
    private ConfigProgram[] _destroyProgram;
    private Set<InjectionPoint> _injectionPointSet;
    private Object _decoratorClass;
    private List<Decorator<?>> _decoratorBeans;

    public CandiProducer(Bean<X> bean, Class<X> instanceClass, Constructor<X> javaCtor, Arg[] args, ConfigProgram[] injectProgram, ConfigProgram[] initProgram, ConfigProgram[] destroyProgram, Set<InjectionPoint> injectionPointSet) {
        this._bean = bean;
        this._instanceClass = instanceClass;
        this._javaCtor = javaCtor;
        this._args = args;
        this._injectProgram = injectProgram;
        this._initProgram = initProgram;
        this._destroyProgram = destroyProgram;
        this._injectionPointSet = injectionPointSet;
        if (injectionPointSet == null) {
            throw new NullPointerException();
        }
        if (instanceClass != null && CandiEnhancedBean.class.isAssignableFrom(instanceClass)) {
            try {
                Method method = instanceClass.getMethod("__caucho_decorator_init", new Class[0]);
                this._decoratorClass = method.invoke(null, new Object[0]);
                Annotation[] qualifiers = new Annotation[bean.getQualifiers().size()];
                bean.getQualifiers().toArray(qualifiers);
                this._decoratorBeans = this._injectManager.resolveDecorators(bean.getTypes(), qualifiers);
                method = instanceClass.getMethod("__caucho_init_decorators", List.class);
                method.invoke(null, this._decoratorBeans);
            }
            catch (InvocationTargetException e) {
                throw ConfigException.create(e.getCause());
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this._injectionPointSet;
    }

    public void bind() {
        for (ConfigProgram program : this._injectProgram) {
            program.bind();
        }
    }

    @Override
    public X produce(CreationalContext<X> ctx) {
        try {
            Decorator<?> dec;
            CreationalContextImpl env = null;
            if (ctx instanceof CreationalContextImpl) {
                env = (CreationalContextImpl)ctx;
            }
            Object[] delegates = null;
            InjectionPoint oldPoint = null;
            InjectionPoint ip = null;
            if (env != null) {
                ip = oldPoint = env.findInjectionPoint();
            }
            if (this._decoratorBeans != null && this._decoratorBeans.size() > 0 && (dec = this._decoratorBeans.get(this._decoratorBeans.size() - 1)) instanceof DecoratorBean && env != null) {
                ip = ((DecoratorBean)dec).getDelegateInjectionPoint();
                env.setInjectionPoint(ip);
            }
            Object[] args = this.evalArgs(env);
            X value = this._javaCtor != null ? this._javaCtor.newInstance(args) : this._instanceClass.newInstance();
            if (env != null) {
                env.push(value);
            }
            if (this._decoratorBeans != null) {
                if (env != null) {
                    env.setInjectionPoint(oldPoint);
                }
                delegates = CandiUtil.generateProxyDelegate(this._injectManager, this._decoratorBeans, this._decoratorClass, env);
                if (env != null) {
                    env.setInjectionPoint(ip);
                }
            }
            if (value instanceof CandiEnhancedBean) {
                CandiEnhancedBean enhancedBean = (CandiEnhancedBean)value;
                Object[] interceptors = null;
                enhancedBean.__caucho_inject(delegates, interceptors, env);
            }
            return value;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new CreationException(e.getCause());
        }
        catch (InstantiationException e) {
            throw new CreationException(L.l("Exception while creating {0}\n  {1}", (Object)(this._javaCtor != null ? this._javaCtor : this._instanceClass), (Object)e), e);
        }
        catch (Exception e) {
            throw new CreationException(e);
        }
        catch (ExceptionInInitializerError e) {
            throw new CreationException(e);
        }
    }

    private Object[] evalArgs(CreationalContextImpl<?> env) {
        Arg[] args = this._args;
        if (args == null) {
            return NULL_ARGS;
        }
        int size = args.length;
        if (size > 0) {
            Object[] argValues = new Object[size];
            for (int i = 0; i < size; ++i) {
                argValues[i] = args[i].eval(env);
            }
            return argValues;
        }
        return NULL_ARGS;
    }

    @Override
    public void inject(X instance, CreationalContext<X> env) {
        try {
            if (instance instanceof CandiEnhancedBean) {
                instance = ((CandiEnhancedBean)instance).__caucho_getDelegate();
            }
            for (ConfigProgram program : this._injectProgram) {
                program.inject(instance, env);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CreationException(e);
        }
    }

    public ConfigProgram[] getPostConstructProgram() {
        return this._initProgram;
    }

    public void setPostConstructProgram(ConfigProgram[] initProgram) {
        this._initProgram = initProgram;
    }

    @Override
    public void postConstruct(X instance) {
        try {
            CreationalContext env = null;
            if (instance instanceof CandiEnhancedBean) {
                CandiEnhancedBean bean = (CandiEnhancedBean)instance;
                bean.__caucho_postConstruct();
            } else {
                for (ConfigProgram program : this._initProgram) {
                    if (program == null) continue;
                    program.inject(instance, env);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CreationException(e);
        }
    }

    @Override
    public void preDestroy(X instance) {
        try {
            CreationalContextImpl<?> env = null;
            if (instance instanceof CandiEnhancedBean) {
                CandiEnhancedBean bean = (CandiEnhancedBean)instance;
                bean.__caucho_destroy(env);
            } else {
                for (ConfigProgram program : this._destroyProgram) {
                    program.inject(instance, env);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CreationException(e);
        }
    }

    @Override
    public void dispose(X instance) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._bean + "]";
    }
}

