/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.DelegateProxyBean;
import com.caucho.config.inject.DependentCreationalContext;
import com.caucho.config.inject.OwnerCreationalContext;
import com.caucho.inject.Module;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class CreationalContextImpl<T>
implements CreationalContext<T> {
    public static final Object NULL = new Object();
    private final Contextual<T> _bean;
    private final CreationalContextImpl<?> _parent;
    private T _value;

    protected CreationalContextImpl(Contextual<T> bean, CreationalContextImpl<?> parent) {
        this._bean = bean;
        this._parent = parent instanceof CreationalContextImpl ? parent : null;
    }

    protected boolean isTop() {
        return false;
    }

    public Contextual<T> getBean() {
        return this._bean;
    }

    protected OwnerCreationalContext<?> getOwner() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    protected DependentCreationalContext<?> getNext() {
        return null;
    }

    protected InjectionPoint getInjectionPoint() {
        return null;
    }

    public void setInjectionPoint(InjectionPoint ip) {
    }

    public T getValue() {
        return this._value;
    }

    public Object getParentValue() {
        return this._parent.getValue();
    }

    public <X> X get(Contextual<X> bean) {
        return CreationalContextImpl.find(this, bean);
    }

    public static <X> X find(CreationalContextImpl<?> ptr, Contextual<X> bean) {
        while (ptr != null) {
            Contextual testBean = ptr._bean;
            if (testBean == bean && ptr._value != null) {
                return (X)ptr._value;
            }
            ptr = ptr._parent;
        }
        return null;
    }

    public static <X> X findWithNull(CreationalContextImpl<?> ptr, Contextual<X> bean) {
        while (ptr != null) {
            Contextual testBean = ptr._bean;
            if (testBean == bean) {
                if (ptr._value != null) {
                    return (X)ptr._value;
                }
                return (X)NULL;
            }
            ptr = ptr._parent;
        }
        return null;
    }

    public <X> X getAny(Contextual<X> bean) {
        return CreationalContextImpl.findAny(this.getOwner(), bean);
    }

    public static <X> X findAny(CreationalContextImpl<?> ptr, Contextual<X> bean) {
        if (ptr == null) {
            return null;
        }
        for (ptr = ptr.getOwner(); ptr != null; ptr = ptr.getNext()) {
            Contextual<?> testBean = ptr.getBean();
            if (testBean != bean && (testBean == null || !testBean.equals(bean))) continue;
            return (X)ptr._value;
        }
        return null;
    }

    public static <X> X findAny(CreationalContextImpl<?> ptr, Class<X> type) {
        if (ptr == null) {
            return null;
        }
        for (ptr = ptr.getOwner(); ptr != null; ptr = ptr.getNext()) {
            if (ptr._value == null || !type.isAssignableFrom(ptr._value.getClass())) continue;
            return (X)ptr._value;
        }
        return null;
    }

    public static Object findByName(CreationalContextImpl<?> ptr, String name) {
        while (ptr != null) {
            Bean bean;
            Contextual testBean = ptr._bean;
            if (testBean instanceof Bean && name.equals((bean = (Bean)testBean).getName())) {
                return ptr._value;
            }
            ptr = ptr._parent;
        }
        return null;
    }

    public InjectionPoint findInjectionPoint() {
        CreationalContextImpl<?> ptr = this;
        while (ptr != null) {
            if (ptr instanceof CreationalContextImpl) {
                CreationalContextImpl<?> env = ptr;
                InjectionPoint ip = env.getInjectionPoint();
                if (ip != null) {
                    return ip;
                }
                ptr = env._parent;
                continue;
            }
            ptr = null;
        }
        return null;
    }

    public Object getDelegate() {
        CreationalContextImpl<?> ptr = this;
        while (ptr != null) {
            if (ptr instanceof CreationalContextImpl) {
                CreationalContextImpl<?> env = ptr;
                if (env._bean == DelegateProxyBean.BEAN) {
                    return env._value;
                }
                ptr = env._parent;
                continue;
            }
            ptr = null;
        }
        return null;
    }

    @Override
    public void push(T value) {
        this._value = value;
    }

    @Module
    public void clearTarget() {
        this._value = null;
    }

    @Override
    public void release() {
        T value = this._value;
        this._value = null;
        if (this._bean != null && value != null) {
            this._bean.destroy(value, this);
        } else {
            DependentCreationalContext<?> next = this.getNext();
            if (next != null) {
                next.release();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._bean + "," + this._value + ",parent=" + this._parent + "]";
    }
}

