/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.inject;

import com.caucho.config.inject.DefaultLiteral;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.InjectionPointImplHandle;
import com.caucho.config.inject.InjectionTargetBuilder;
import com.caucho.inject.Module;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class InjectionPointImpl<T>
implements InjectionPoint,
Serializable {
    private final InjectManager _manager;
    private InjectionTargetBuilder<T> _target;
    private final Bean<T> _bean;
    private final Annotated _annotated;
    private final Member _member;
    private final HashSet<Annotation> _qualifiers = new HashSet();
    private Type _type;

    InjectionPointImpl(InjectManager manager, Bean<T> bean, AnnotatedField<T> field) {
        this(manager, bean, field, field.getJavaMember(), field.getBaseType());
    }

    InjectionPointImpl(InjectManager manager, InjectionTargetBuilder<T> target, AnnotatedField<T> field) {
        this(manager, target.getBean(), field, field.getJavaMember(), field.getBaseType());
        this._target = target;
    }

    public InjectionPointImpl(InjectManager manager, Bean<T> bean, AnnotatedParameter<?> param) {
        this(manager, bean, param, param.getDeclaringCallable().getJavaMember(), param.getBaseType());
    }

    InjectionPointImpl(InjectManager manager, InjectionTargetBuilder<T> target, AnnotatedParameter<?> param) {
        this(manager, target.getBean(), param, param.getDeclaringCallable().getJavaMember(), param.getBaseType());
        this._target = target;
    }

    public InjectionPointImpl(InjectManager manager, Bean<T> bean, Annotated annotated, Member member, Type type) {
        this._manager = manager;
        this._bean = bean;
        this._annotated = annotated;
        this._member = member;
        this._type = type;
        boolean isQualifier = false;
        for (Annotation ann : annotated.getAnnotations()) {
            if (!this._manager.isQualifier(ann.annotationType())) continue;
            this._qualifiers.add(ann);
            isQualifier = true;
        }
        if (!isQualifier) {
            this._qualifiers.add(DefaultLiteral.DEFAULT);
        }
    }

    @Override
    public Type getType() {
        if (this._type != null) {
            return this._type;
        }
        return this._annotated.getBaseType();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this._qualifiers;
    }

    @Override
    public Bean<?> getBean() {
        if (this._bean != null) {
            return this._bean;
        }
        if (this._target != null) {
            return this._target.getBean();
        }
        return null;
    }

    @Override
    public Member getMember() {
        return this._member;
    }

    @Override
    public Annotated getAnnotated() {
        return this._annotated;
    }

    @Override
    public boolean isDelegate() {
        return this._annotated.isAnnotationPresent(Delegate.class);
    }

    @Override
    public boolean isTransient() {
        int modifiers = this._member.getModifiers();
        return Modifier.isTransient(modifiers);
    }

    private Object writeReplace() {
        return new InjectionPointImplHandle(this._bean.getBeanClass().getName(), this._bean.getQualifiers(), this.getMember(), this._qualifiers, ((Class)this.getType()).getName());
    }

    public int hashCode() {
        return this._member.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != InjectionPointImpl.class) {
            return false;
        }
        InjectionPointImpl ip = (InjectionPointImpl)o;
        return this._member.equals(ip._member);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getMember() + "]";
    }
}

