/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.j2ee.JavaeeInjectionHandler;
import com.caucho.config.j2ee.JndiValueGenerator;
import com.caucho.config.program.BeanValueGenerator;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.FieldGeneratorProgram;
import com.caucho.config.program.MethodGeneratorProgram;
import com.caucho.config.program.NullProgram;
import com.caucho.config.program.ValueGenerator;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.annotation.Resources;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceHandler
extends JavaeeInjectionHandler {
    private static final L10N L = new L10N(ResourceHandler.class);
    private static final Logger log = Logger.getLogger(ResourceHandler.class.getName());
    private static final HashMap<Class<?>, Class<?>> _boxingMap = new HashMap();
    private static final Method _lookupMethod;

    public ResourceHandler(InjectManager manager) {
        super(manager);
    }

    @Override
    public ConfigProgram introspectField(AnnotatedField<?> field) {
        Resource resource = field.getAnnotation(Resource.class);
        Field javaField = field.getJavaMember();
        String loc = this.getLocation(javaField);
        String jndiName = javaField.getDeclaringClass().getName() + "/" + javaField.getName();
        Class<?> bindType = javaField.getType();
        ValueGenerator gen = this.generateContext(loc, bindType, jndiName, resource);
        this.bindJndi(javaField, gen);
        return new FieldGeneratorProgram(field.getJavaMember(), gen);
    }

    @Override
    public ConfigProgram introspectMethod(AnnotatedMethod<?> method) {
        Resource resource = method.getAnnotation(Resource.class);
        Method javaMethod = method.getJavaMember();
        String loc = this.getLocation(method.getJavaMember());
        String jndiName = javaMethod.getDeclaringClass().getName() + "/" + javaMethod.getName();
        Class<?> bindType = javaMethod.getParameterTypes()[0];
        ValueGenerator gen = this.generateContext(loc, bindType, jndiName, resource);
        this.bindJndi(javaMethod, gen);
        return new MethodGeneratorProgram(method.getJavaMember(), gen);
    }

    @Override
    public ConfigProgram introspectType(AnnotatedType<?> type) {
        Resource resource;
        for (Class<?> parentClass = type.getJavaClass().getSuperclass(); parentClass != null; parentClass = parentClass.getSuperclass()) {
            Resource resource2;
            Resources resources = parentClass.getAnnotation(Resources.class);
            if (resources != null) {
                for (Resource resource3 : resources.value()) {
                    this.introspectClass(this.getClass().getName(), resource3);
                }
            }
            if ((resource2 = parentClass.getAnnotation(Resource.class)) == null) continue;
            this.introspectClass(this.getClass().getName(), resource2);
        }
        Resources resources = type.getAnnotation(Resources.class);
        if (resources != null) {
            for (Resource resource4 : resources.value()) {
                this.introspectClass(this.getClass().getName(), resource4);
            }
        }
        if ((resource = type.getAnnotation(Resource.class)) != null) {
            this.introspectClass(this.getClass().getName(), resource);
        }
        return new NullProgram();
    }

    private void introspectClass(String location, Resource resource) {
        String name = resource.name();
        Class bindType = resource.type();
        if ("".equals(name)) {
            throw new ConfigException(L.l("{0}: @Resource name() attribute is required for @Resource on a class.", (Object)location));
        }
        if (Object.class.equals((Object)bindType)) {
            throw new ConfigException(L.l("{0}: @Resource beanInterface() attribute is required for @Resource on a class.", (Object)location));
        }
        ValueGenerator gen = this.generateContext(location, bindType, null, resource);
        if (name != null && !"".equals(name)) {
            this.bindJndi(name, gen, name);
        }
    }

    private ValueGenerator generateContext(String loc, Class<?> bindType, String fullJndiName, Resource resource) throws ConfigException {
        String name = resource.name();
        String mappedName = resource.mappedName();
        String lookupName = null;
        if (_lookupMethod != null) {
            try {
                lookupName = (String)_lookupMethod.invoke((Object)resource, new Object[0]);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (!resource.type().equals(Object.class) && !resource.type().equals(Void.TYPE)) {
            bindType = resource.type();
        }
        ValueGenerator gen = null;
        gen = lookupName != null && !"".equals(lookupName) ? new JndiValueGenerator(loc, bindType, lookupName) : this.lookupJndi(loc, bindType, name);
        if (gen != null) {
            if (fullJndiName != null) {
                this.bindJndi(null, gen, fullJndiName);
            }
        } else {
            gen = this.bindValueGenerator(loc, bindType, name, mappedName);
            this.bindJndi(name, gen, fullJndiName);
        }
        return gen;
    }

    private ValueGenerator lookupJndi(String loc, Class<?> bindType, String lookupName) {
        Object value;
        if (lookupName == null || "".equals(lookupName)) {
            return null;
        }
        if (!lookupName.startsWith("java:") && !lookupName.startsWith("/")) {
            lookupName = "java:comp/env/" + lookupName;
        }
        if ((value = Jndi.lookup(lookupName)) != null) {
            return new JndiValueGenerator(loc, bindType, lookupName);
        }
        return null;
    }

    private ValueGenerator bindValueGenerator(String location, Class<?> bindType, String name, String mappedName) {
        Bean<?> bean;
        Class<?> boxedType = _boxingMap.get(bindType);
        if (boxedType != null) {
            bindType = boxedType;
        }
        if ((bean = this.bind(location, bindType, name, new Annotation[0])) == null) {
            bean = this.bind(location, bindType, mappedName, new Annotation[0]);
        }
        if (bean == null) {
            if (!"".equals(name)) {
                throw new ConfigException(location + L.l("name='{0}' is an unknown @Resource.", (Object)name));
            }
            if (!"".equals(mappedName)) {
                throw new ConfigException(location + L.l("mappedName='{0}' is an unknown @Resource.", (Object)mappedName));
            }
            throw new ConfigException(location + L.l("@Resource cannot find any matching resources with type='{0}' in {1}", (Object)bindType, (Object)this.getManager()));
        }
        return new BeanValueGenerator(location, bean);
    }

    static {
        _boxingMap.put(Boolean.TYPE, Boolean.class);
        _boxingMap.put(Character.TYPE, Character.class);
        _boxingMap.put(Byte.TYPE, Byte.class);
        _boxingMap.put(Short.TYPE, Short.class);
        _boxingMap.put(Integer.TYPE, Integer.class);
        _boxingMap.put(Long.TYPE, Long.class);
        _boxingMap.put(Float.TYPE, Float.class);
        _boxingMap.put(Double.TYPE, Double.class);
        Method lookupMethod = null;
        try {
            lookupMethod = Resource.class.getMethod("lookup", new Class[0]);
        }
        catch (Exception e) {
            log.log(Level.ALL, e.toString(), e);
        }
        _lookupMethod = lookupMethod;
    }
}

