/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.reflect;

import com.caucho.config.inject.InjectManager;
import com.caucho.config.reflect.BaseType;
import com.caucho.config.reflect.BaseTypeAnnotated;
import com.caucho.inject.Module;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public class AnnotatedTypeUtil {
    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, AnnotatedMethod<?> method) {
        return AnnotatedTypeUtil.findMethod(type.getMethods(), method);
    }

    public static <X> AnnotatedMethod<? super X> findMethod(Collection<AnnotatedMethod<? super X>> methodList, AnnotatedMethod<?> method) {
        Method javaMethod = method.getJavaMember();
        String name = javaMethod.getName();
        List<AnnotatedParameter<?>> paramList = method.getParameters();
        for (AnnotatedMethod<X> testMethod : methodList) {
            List<AnnotatedParameter<?>> testParamList;
            Method testJavaMethod = testMethod.getJavaMember();
            if (!name.equals(testJavaMethod.getName()) || !AnnotatedTypeUtil.isMatch(paramList, testParamList = testMethod.getParameters())) continue;
            return testMethod;
        }
        return null;
    }

    private static boolean isMatch(List<AnnotatedParameter<?>> listA, List<AnnotatedParameter<?>> listB) {
        if (listA.size() != listB.size()) {
            return false;
        }
        int len = listA.size();
        for (int i = 0; i < len; ++i) {
            if (listA.get(i).getBaseType().equals(listB.get(i).getBaseType())) continue;
            return false;
        }
        return true;
    }

    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, Method javaMethod) {
        return AnnotatedTypeUtil.findMethod(type, javaMethod.getName(), javaMethod.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> findMethod(AnnotatedType<X> type, String methodName, Class<?>[] param) {
        for (AnnotatedMethod<X> annMethod : type.getMethods()) {
            Method method = annMethod.getJavaMember();
            if (!method.getName().equals(methodName) || !AnnotatedTypeUtil.isMatch(param, method.getParameterTypes())) continue;
            return annMethod;
        }
        return null;
    }

    public static <X> AnnotatedMethod<? super X> findMethod(Set<AnnotatedMethod<? super X>> methods, Method method) {
        return AnnotatedTypeUtil.findMethod(methods, method.getName(), method.getParameterTypes());
    }

    public static <X> AnnotatedMethod<? super X> findMethod(Set<AnnotatedMethod<? super X>> methods, String methodName, Class<?>[] param) {
        for (AnnotatedMethod<X> annMethod : methods) {
            Method method = annMethod.getJavaMember();
            if (!method.getName().equals(methodName) || !AnnotatedTypeUtil.isMatch(param, method.getParameterTypes())) continue;
            return annMethod;
        }
        return null;
    }

    public static Method findDeclaredMethod(Class<?> cl, Method testMethod) {
        if (cl == null) {
            return null;
        }
        for (Method method : cl.getDeclaredMethods()) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static Method findMethod(Method[] methods, Method testMethod) {
        for (Method method : methods) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static Method findMethod(Collection<Method> methods, Method testMethod) {
        for (Method method : methods) {
            if (!AnnotatedTypeUtil.isMatch(method, testMethod)) continue;
            return method;
        }
        return null;
    }

    public static boolean isMatch(AnnotatedMethod<?> methodA, AnnotatedMethod<?> methodB) {
        List<AnnotatedParameter<?>> paramListB;
        if (methodA == methodB) {
            return true;
        }
        if (methodA == null || methodB == null) {
            return false;
        }
        Method javaMethodA = methodA.getJavaMember();
        Method javaMethodB = methodB.getJavaMember();
        if (!javaMethodA.getName().equals(javaMethodB.getName())) {
            return false;
        }
        List<AnnotatedParameter<?>> paramListA = methodA.getParameters();
        return AnnotatedTypeUtil.isMatch(paramListA, paramListB = methodB.getParameters());
    }

    public static boolean isMatch(AnnotatedMethod<?> method, String name, Class<?>[] param) {
        Method javaMethod = method.getJavaMember();
        if (!javaMethod.getName().equals(name)) {
            return false;
        }
        Class<?>[] mparam = javaMethod.getParameterTypes();
        return AnnotatedTypeUtil.isMatch(mparam, param);
    }

    public static boolean isMatch(Method javaMethod, String name, Class<?>[] param) {
        if (!javaMethod.getName().equals(name)) {
            return false;
        }
        Class<?>[] mparam = javaMethod.getParameterTypes();
        return AnnotatedTypeUtil.isMatch(mparam, param);
    }

    public static boolean isMatch(Method methodA, Method methodB) {
        if (!methodA.getName().equals(methodB.getName())) {
            return false;
        }
        return AnnotatedTypeUtil.isMatch(methodA.getParameterTypes(), methodB.getParameterTypes());
    }

    public static boolean isMatch(Class<?>[] paramA, Class<?>[] paramB) {
        if (paramA.length != paramB.length) {
            return false;
        }
        for (int i = paramA.length - 1; i >= 0; --i) {
            if (paramA[i].equals(paramB[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasException(AnnotatedMethod<?> method, Class<?> exn) {
        Class<?>[] methodExceptions = method.getJavaMember().getExceptionTypes();
        for (int j = 0; j < methodExceptions.length; ++j) {
            if (!methodExceptions[j].isAssignableFrom(exn)) continue;
            return true;
        }
        return false;
    }

    public static BaseType getBaseType(Annotated annotated) {
        if (annotated instanceof BaseTypeAnnotated) {
            return ((BaseTypeAnnotated)((Object)annotated)).getBaseTypeImpl();
        }
        return InjectManager.create().createTargetBaseType(annotated.getBaseType());
    }
}

