/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.scope;

import com.caucho.config.scope.ContextContainer;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Module
public abstract class AbstractScopeContext
implements Context {
    public static final L10N L = new L10N(AbstractScopeContext.class);

    @Override
    public abstract boolean isActive();

    @Override
    public abstract Class<? extends Annotation> getScope();

    @Override
    public <T> T get(Contextual<T> bean) {
        if (!this.isActive()) {
            throw new ContextNotActiveException(L.l("{0} cannot be used because it's not currently active", (Object)this.getClass().getName()));
        }
        ContextContainer context = this.getContextContainer();
        if (context == null) {
            return null;
        }
        Object key = bean;
        if (bean instanceof PassivationCapable) {
            key = ((PassivationCapable)((Object)bean)).getId();
        }
        return (T)context.get(key);
    }

    @Override
    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object result;
        if (!this.isActive()) {
            throw new ContextNotActiveException(L.l("{0} cannot be used because it's not currently active", (Object)this.getClass().getName()));
        }
        ContextContainer context = this.createContextContainer();
        if (context == null) {
            return null;
        }
        Object key = bean;
        if (bean instanceof PassivationCapable) {
            key = ((PassivationCapable)((Object)bean)).getId();
        }
        if ((result = context.get(key)) != null || creationalContext == null) {
            return (T)result;
        }
        result = this.create(bean, creationalContext);
        context.put(bean, key, result, creationalContext);
        return (T)result;
    }

    protected <T> T create(Contextual<T> bean, CreationalContext<T> env) {
        return bean.create(env);
    }

    protected abstract ContextContainer getContextContainer();

    protected abstract ContextContainer createContextContainer();

    public void closeContext() {
        ContextContainer context = this.getContextContainer();
        if (context != null) {
            context.close();
        }
    }
}

