/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.ListType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayType<T, X>
extends ConfigType<T> {
    private static final L10N L = new L10N(ArrayType.class);
    private static final Logger log = Logger.getLogger(ListType.class.getName());
    private final ConfigType<X> _componentType;
    private final Class<X> _componentClass;
    private final Class<T> _type;

    public ArrayType(ConfigType<X> componentType, Class<X> componentClass) {
        this._componentType = componentType;
        this._componentClass = componentClass;
        Class<?> type = null;
        try {
            type = Array.newInstance(componentClass, 0).getClass();
        }
        catch (Exception e) {
            // empty catch block
        }
        this._type = type;
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public ConfigType<X> getComponentType() {
        return this._componentType;
    }

    @Override
    public Class<T> getType() {
        return this._type;
    }

    @Override
    public boolean isInlineType(ConfigType<?> type) {
        return this._componentType.getType().isAssignableFrom(type.getType());
    }

    @Override
    public Object create(Object parent, QName name) {
        Object value = this.getComponentType().create(parent, name);
        if (value != null) {
            return value;
        }
        return new ArrayList();
    }

    @Override
    public Attribute getAttribute(QName name) {
        return TypeFactory.getFactory().getListAttribute(name);
    }

    @Override
    public Object replaceObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            List list = (List)value;
            Object[] array = (Object[])Array.newInstance(this._componentClass, list.size());
            list.toArray(array);
            return array;
        }
        value = this._componentType.replaceObject(value);
        Object[] array = (Object[])Array.newInstance(this._componentClass, 1);
        Array.set(array, 0, value);
        return array;
    }

    @Override
    public Object valueOf(String text) {
        Object value = this._componentType.valueOf(text);
        Object[] valueArray = (Object[])Array.newInstance(this._componentClass, 1);
        Array.set(valueArray, 0, value);
        return valueArray;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._componentClass.getName() + "]";
    }
}

