/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.type.ConfigType;
import com.caucho.util.L10N;

public final class DoublePrimitiveType
extends ConfigType {
    private static final L10N L = new L10N(DoublePrimitiveType.class);
    public static final DoublePrimitiveType TYPE = new DoublePrimitiveType();
    private static final Double ZERO = new Double(0.0);

    private DoublePrimitiveType() {
    }

    public Class getType() {
        return Double.TYPE;
    }

    public Object valueOf(String text) {
        if (text == null || text.length() == 0) {
            return ZERO;
        }
        return Double.valueOf(text);
    }

    public Object valueOf(Object value) {
        if (value instanceof Double) {
            return value;
        }
        if (value == null) {
            return ZERO;
        }
        if (value instanceof String) {
            return this.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Double(((Number)value).doubleValue());
        }
        throw new ConfigException(L.l("'{0}' cannot be converted to a double", value));
    }
}

