/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.type;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListType
extends ConfigType {
    private static final L10N L = new L10N(ListType.class);
    private static final Logger log = Logger.getLogger(ListType.class.getName());
    private final Class<?> _listClass;
    private final Class<?> _instanceClass;

    public ListType() {
        this(ArrayList.class);
    }

    public ListType(Class<?> listClass) {
        this._listClass = listClass;
        this._instanceClass = !this._listClass.isInterface() && Modifier.isAbstract(this._listClass.getModifiers()) ? this._listClass : ArrayList.class;
    }

    public Class<?> getType() {
        return this._listClass;
    }

    @Override
    public String getTypeName() {
        return this.getType().getName() + "[]";
    }

    public Object create(Object parent) {
        try {
            return this._instanceClass.newInstance();
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    @Override
    public Attribute getAttribute(QName name) {
        Attribute attr = TypeFactory.getFactory().getListAttribute(name);
        return attr;
    }

    @Override
    public Object valueOf(String text) {
        if ("".equals(text.trim())) {
            return null;
        }
        throw new ConfigException(L.l("Can't convert to '{0}' from '{1}'.", (Object)this._listClass.getName(), (Object)text));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._listClass.getName() + "]";
    }
}

