/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.types;

import com.caucho.config.ConfigException;
import com.caucho.config.annotation.NoAspect;
import com.caucho.config.types.PathPatternType;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NoAspect
public class FileSetType {
    static final L10N L = new L10N(PathPatternType.class);
    static final Logger log = Logger.getLogger(PathPatternType.class.getName());
    private Path _dir;
    private String _userPathPrefix = "";
    private String _valuePath;
    private ArrayList<PathPatternType> _includeList;
    private ArrayList<PathPatternType> _excludeList = new ArrayList();

    public void setDir(Path dir) {
        this._dir = dir;
    }

    public Path getDir() {
        return this._dir;
    }

    public void addInclude(PathPatternType pattern) {
        if (this._includeList == null) {
            this._includeList = new ArrayList();
        }
        this._includeList.add(pattern);
    }

    public void addText(String text) {
        if ("".equals(text)) {
            return;
        }
        int starP = text.indexOf(42);
        if (starP > 0) {
            int colonP = text.indexOf(58);
            int slashP = text.lastIndexOf(47, starP);
            if (colonP > 0 && colonP < slashP) {
                String prefix = text.substring(0, slashP);
                this._dir = Vfs.lookup(prefix);
                this.addInclude(new PathPatternType(text.substring(slashP + 1)));
                return;
            }
            if (slashP >= 0) {
                String prefix = text.substring(0, slashP);
                this.addInclude(new PathPatternType(prefix, text));
                return;
            }
        }
        this.addInclude(new PathPatternType(text));
    }

    public void addExclude(PathPatternType pattern) {
        this._excludeList.add(pattern);
    }

    public void add(FileSetType fileSet) {
        if (fileSet == this) {
            return;
        }
        if (this._dir == null) {
            this._dir = fileSet.getDir();
        }
        if (!this.isSameDir(fileSet)) {
            throw new IllegalArgumentException(L.l("fileset directory: mismatch can't add {0} to {1}", (Object)fileSet, (Object)this));
        }
        if (fileSet._includeList != null) {
            for (PathPatternType include : fileSet._includeList) {
                this.addInclude(include);
            }
        }
        if (fileSet._excludeList != null) {
            for (PathPatternType exclude : fileSet._excludeList) {
                this.addExclude(exclude);
            }
        }
    }

    public void addInverse(FileSetType fileSet) {
        if (fileSet == this) {
            return;
        }
        if (this._dir == null) {
            this._dir = fileSet.getDir();
        }
        if (!this.isSameDir(fileSet)) {
            throw new IllegalArgumentException(L.l("fileset directory mismatch: can't add {0} to {1}", (Object)fileSet, (Object)this));
        }
        if (fileSet._includeList != null) {
            for (PathPatternType include : fileSet._includeList) {
                this.addExclude(include);
            }
        }
        if (fileSet._excludeList != null) {
            for (PathPatternType exclude : fileSet._excludeList) {
                this.addInclude(exclude);
            }
        }
    }

    public void setUserPathPrefix(String prefix) {
        this._userPathPrefix = prefix != null && !prefix.equals("") && !prefix.endsWith("/") ? prefix + "/" : prefix;
    }

    @PostConstruct
    public void init() throws ConfigException {
        if (this._dir == null) {
            this._dir = Vfs.lookup();
        }
    }

    public ArrayList<Path> getPaths() {
        return this.getPaths(new ArrayList<Path>());
    }

    public ArrayList<Path> getPaths(ArrayList<Path> paths) {
        PathListCallback cb = new PathListCallback(paths);
        this.filterPaths(cb);
        Collections.sort(paths);
        return paths;
    }

    public void filterPaths(PathCallback cb) {
        String dirPath = this._dir.getPath();
        if (!dirPath.endsWith("/")) {
            dirPath = dirPath + "/";
        }
        this.filterPaths(this._dir, dirPath, cb);
    }

    public void filterPaths(Path path, String prefix, PathCallback cb) {
        if (!path.exists() || !path.canRead()) {
            return;
        }
        if (!this.isValidPrefix(path, prefix)) {
            return;
        }
        if (path.isDirectory()) {
            try {
                String[] list = path.list();
                for (int i = 0; i < list.length; ++i) {
                    String name = list[i];
                    if (".".equals(name) || "..".equals(name)) continue;
                    Path subpath = path.lookup("./" + name);
                    this.filterPaths(subpath, prefix, cb);
                }
            }
            catch (IOException e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        if (path.exists() && this.isMatch(path, prefix)) {
            String suffix = "";
            String fullPath = path.getPath();
            if (prefix.length() < fullPath.length()) {
                suffix = path.getPath().substring(prefix.length());
            }
            path.setUserPath(this._userPathPrefix + suffix);
            cb.onMatch(path);
        }
    }

    private boolean isValidPrefix(Path path, String prefix) {
        String suffix = "";
        String fullPath = path.getPath();
        if (prefix.length() < fullPath.length()) {
            suffix = path.getPath().substring(prefix.length());
        }
        if (this._includeList == null || this._includeList.size() == 0) {
            return true;
        }
        for (PathPatternType pattern : this._includeList) {
            if (!pattern.isValidPrefix(suffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isMatch(Path path, String prefix) {
        PathPatternType pattern;
        int i;
        String suffix = "";
        String fullPath = path.getPath();
        if (prefix.length() < fullPath.length()) {
            suffix = fullPath.substring(prefix.length());
        }
        for (i = 0; i < this._excludeList.size(); ++i) {
            pattern = this._excludeList.get(i);
            if (!pattern.isMatch(suffix)) continue;
            return false;
        }
        if (this._includeList == null) {
            return true;
        }
        for (i = 0; i < this._includeList.size(); ++i) {
            pattern = this._includeList.get(i);
            if (!pattern.isMatch(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameDir(FileSetType fileSet) {
        if (fileSet == null) {
            throw new NullPointerException();
        }
        if (this._dir == fileSet._dir) {
            return true;
        }
        return this._dir != null && this._dir.equals(fileSet._dir);
    }

    public ArrayList<Path> getRoots() {
        ArrayList<Path> roots = new ArrayList<Path>();
        if (this._includeList == null || this._includeList.size() == 0) {
            roots.add(this._dir);
            return roots;
        }
        for (PathPatternType pattern : this._includeList) {
            String prefix = pattern.getPrefix();
            if (prefix == null || "".equals(prefix)) {
                roots.add(this._dir);
                return roots;
            }
            roots.add(this._dir.lookup(prefix));
        }
        return roots;
    }

    public String toString() {
        return "FileSetType[" + this._dir + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathListCallback
    implements PathCallback {
        private ArrayList<Path> _list = new ArrayList();

        private PathListCallback(ArrayList<Path> list) {
            this._list = list;
        }

        public ArrayList<Path> getList() {
            return this._list;
        }

        @Override
        public void onMatch(Path path) {
            this._list.add(path);
        }

        public String toString() {
            return this.getClass().getSimpleName() + this._list;
        }
    }

    public static interface PathCallback {
        public void onMatch(Path var1);
    }
}

