/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.config.xml;

import com.caucho.config.ConfigException;
import com.caucho.config.attribute.Attribute;
import com.caucho.config.cfg.BeanConfig;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.type.ConfigType;
import com.caucho.config.type.TypeFactory;
import com.caucho.config.types.AnnotationConfig;
import com.caucho.config.xml.XmlBeanConfig;
import com.caucho.config.xml.XmlConfigContext;
import com.caucho.util.L10N;
import com.caucho.xml.QName;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.enterprise.context.spi.CreationalContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBeanAttribute
extends Attribute {
    private static final L10N L = new L10N(XmlBeanAttribute.class);
    public static final XmlBeanAttribute ATTRIBUTE = new XmlBeanAttribute();
    private final ConfigType<?> _configType;
    private final Method _setMethod;

    private XmlBeanAttribute() {
        this(null, TypeFactory.getType(XmlBeanConfig.class));
    }

    public XmlBeanAttribute(Method setMethod, ConfigType<?> configType) {
        this._configType = configType;
        this._setMethod = setMethod;
    }

    @Override
    public ConfigType<?> getConfigType() {
        return this._configType;
    }

    @Override
    public Object create(Object parent, QName qName) throws ConfigException {
        String uri = qName.getNamespaceURI();
        String localName = qName.getLocalName();
        if (uri.equals("urn:java:com.caucho.config.driver")) {
            TypeFactory factory = TypeFactory.getFactory();
            Class<?> api = parent instanceof BeanConfig ? ((BeanConfig)parent).getBeanConfigClass() : (this._setMethod != null ? this._setMethod.getParameterTypes()[0] : this._configType.getType());
            Class<?> cl = factory.getDriverClassByScheme(api, localName);
            return new XmlBeanConfig(qName, cl, parent);
        }
        if (!uri.startsWith("urn:java:")) {
            throw new IllegalStateException(L.l("'{0}' is an unexpected namespace, expected 'urn:java:...'", (Object)uri));
        }
        String pkg = uri.substring("uri:java:".length());
        ConfigType<?> type = TypeFactory.getFactory().getEnvironmentType(qName);
        if (type != null && type.isEnvBean()) {
            return type.create(parent, qName);
        }
        Class<?> cl = TypeFactory.loadClass(pkg, localName);
        if (cl == null) {
            throw new ConfigException(L.l("'{0}.{1}' is an unknown class for element '{2}'", (Object)pkg, (Object)localName, (Object)qName));
        }
        if (Annotation.class.isAssignableFrom(cl)) {
            return new AnnotationConfig(cl);
        }
        XmlBeanConfig config = new XmlBeanConfig(qName, cl, parent);
        return config;
    }

    @Override
    public void setText(Object bean, QName name, String value) throws ConfigException {
        Object beanChild = this.create(bean, name);
        if (beanChild instanceof XmlBeanConfig) {
            XmlBeanConfig config = (XmlBeanConfig)beanChild;
            if (!value.trim().equals("")) {
                config.addArg(new TextArgProgram(value));
            }
            config.init();
        } else {
            ConfigType<?> childType = TypeFactory.getType(beanChild);
            childType.setProperty(beanChild, XmlConfigContext.TEXT, value);
            childType.init(beanChild);
        }
        this.setValue(bean, name, beanChild);
    }

    @Override
    public void setValue(Object bean, QName name, Object value) throws ConfigException {
        try {
            if (value instanceof AnnotationConfig) {
                value = ((AnnotationConfig)value).replace();
            }
            if (this._setMethod != null && value != null) {
                if (!this._setMethod.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    throw new ConfigException(L.l("'{0}.{1}' is not assignable from {2}", (Object)this._setMethod.getDeclaringClass().getSimpleName(), (Object)this._setMethod.getName(), value));
                }
                this._setMethod.invoke(bean, value);
            }
        }
        catch (Exception e) {
            throw ConfigException.create(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TextArgProgram
    extends ConfigProgram {
        private String _arg;

        TextArgProgram(String arg) {
            this._arg = arg;
        }

        @Override
        public <T> void inject(T bean, CreationalContext<T> env) {
            throw new UnsupportedOperationException(this.getClass().getName());
        }

        @Override
        public <T> T create(ConfigType<T> type, CreationalContext<T> env) throws ConfigException {
            return (T)type.valueOf(this._arg);
        }
    }
}

