/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db;

import com.caucho.db.block.BlockManager;
import com.caucho.db.lock.DatabaseLock;
import com.caucho.db.sql.Parser;
import com.caucho.db.sql.Query;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableFactory;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.CloseListener;
import com.caucho.loader.Environment;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;

public class Database {
    private static final Logger log = Logger.getLogger(Database.class.getName());
    private static final L10N L = new L10N(Database.class);
    private Path _dir;
    private BlockManager _blockManager;
    private HashMap<String, Table> _tables = new HashMap();
    private LruCache<String, Query> _cachedQueries = new LruCache(128);
    private DatabaseLock _databaseLock = new DatabaseLock("db");
    private boolean _removeOnError;
    private boolean _isFlushDirtyBlocksOnCommit = true;
    private final Lifecycle _lifecycle = new Lifecycle(log, null, Level.FINER);

    public Database() {
        this(null);
    }

    public Database(Path dir) {
        Environment.addClassLoaderListener(new CloseListener(this));
        this._lifecycle.setName(this.toString());
        if (dir != null) {
            this.setPath(dir);
        }
        this._blockManager = BlockManager.create();
    }

    public void setPath(Path dir) {
        this._dir = dir;
    }

    public void setRemoveOnError(boolean remove) {
        this._removeOnError = remove;
    }

    public void setFlushDirtyBlocksOnCommit(boolean isFlush) {
        this._isFlushDirtyBlocksOnCommit = isFlush;
    }

    public boolean isFlushDirtyBlocksOnCommit() {
        return this._isFlushDirtyBlocksOnCommit;
    }

    public void ensureMemoryCapacity(long minCapacity) {
        int minBlocks = (int)((minCapacity + 8192L - 1L) / 8192L);
        this._blockManager.ensureCapacity(minBlocks);
    }

    @PostConstruct
    public void init() throws SQLException {
        if (!this._lifecycle.toActive()) {
            return;
        }
    }

    public Path getPath() {
        return this._dir;
    }

    public BlockManager getBlockManager() {
        return this._blockManager;
    }

    public DatabaseLock getDatabaseLock() {
        return this._databaseLock;
    }

    public TableFactory createTableFactory() {
        return new TableFactory(this);
    }

    public void addTable(Table table) throws IOException {
        log.fine("adding table " + table.getName());
        table.setFlushDirtyBlocksOnCommit(this._isFlushDirtyBlocksOnCommit);
        table.init();
        this._tables.put(table.getName(), table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Table getTable(String name) {
        HashMap<String, Table> hashMap = this._tables;
        synchronized (hashMap) {
            Table table = this._tables.get(name);
            if (table != null) {
                return table;
            }
            Path dir = this._dir;
            if (dir == null) {
                return null;
            }
            try {
                table = Table.loadFromFile(this, name);
                if (table == null) {
                    return null;
                }
                table.setFlushDirtyBlocksOnCommit(this._isFlushDirtyBlocksOnCommit);
                table.init();
                this._tables.put(name, table);
                return table;
            }
            catch (Exception e) {
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, e.toString(), e);
                }
                if (this._removeOnError) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, e.toString(), e);
                    } else {
                        log.warning(e.toString());
                    }
                    try {
                        dir.lookup(name + ".db").remove();
                    }
                    catch (IOException e1) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropTable(String name) throws SQLException {
        Table table = null;
        Database database = this;
        synchronized (database) {
            table = this.getTable(name);
            if (table == null) {
                throw new SQLException(L.l("Table {0} does not exist.  DROP TABLE can only drop an existing table.", (Object)name));
            }
            this._tables.remove(name);
            this._cachedQueries.clear();
        }
        table.remove();
    }

    public Query parseQuery(String sql) throws SQLException {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + ": " + sql);
        }
        Query query = Parser.parse(this, sql);
        return query;
    }

    public void close() {
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        for (Table table : this._tables.values()) {
            try {
                table.close();
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._dir + "]";
    }
}

