/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.BlockManager;
import com.caucho.env.service.AbstractResinSubSystem;
import com.caucho.env.service.ResinSystem;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Logger;

public class BlockManagerSubSystem
extends AbstractResinSubSystem {
    private static final Logger log = Logger.getLogger(BlockManagerSubSystem.class.getName());
    private static final L10N L = new L10N(BlockManagerSubSystem.class);
    public static final int START_PRIORITY = 100;
    public static final int STOP_PRIORITY = 35;
    public static final long BLOCK_FLUSH_PERIOD = 300000L;
    private static final AtomicReference<BlockManagerSubSystem> _activeService = new AtomicReference();
    private Alarm _blockFlushAlarm;
    private Lifecycle _lifecycle = new Lifecycle();

    private BlockManagerSubSystem() {
    }

    public static BlockManagerSubSystem createAndAddService() {
        ResinSystem system = BlockManagerSubSystem.preCreate(BlockManagerSubSystem.class);
        BlockManagerSubSystem service = new BlockManagerSubSystem();
        system.addService(BlockManagerSubSystem.class, service);
        return service;
    }

    public static BlockManagerSubSystem getCurrent() {
        return ResinSystem.getCurrentService(BlockManagerSubSystem.class);
    }

    public int getStartPriority() {
        return 100;
    }

    public void start() {
        this._lifecycle.toActive();
        this._blockFlushAlarm = new Alarm(new BlockFlushHandler());
        this._blockFlushAlarm.queue(0L);
    }

    public void stop() {
        BlockManager blockManager;
        this._lifecycle.toStop();
        Alarm alarm = this._blockFlushAlarm;
        this._blockFlushAlarm = null;
        if (alarm != null) {
            alarm.dequeue();
        }
        if ((blockManager = BlockManager.getBlockManager()) != null) {
            blockManager.destroy();
        }
    }

    class BlockFlushHandler
    implements AlarmListener {
        BlockFlushHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleAlarm(Alarm alarm) {
            try {
                BlockManager manager = BlockManager.getBlockManager();
                if (manager != null) {
                    manager.flush();
                }
                Object var4_3 = null;
                if (BlockManagerSubSystem.this._lifecycle.isActive()) {
                    alarm.queue(300000L);
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (BlockManagerSubSystem.this._lifecycle.isActive()) {
                    alarm.queue(300000L);
                }
                throw throwable;
            }
        }
    }
}

